/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.g2d.tooltip;

import java.awt.geom.Point2D;
import org.simantics.g2d.canvas.impl.DependencyReflection;
import org.simantics.g2d.diagram.participant.pointertool.PointerInteractor;
import org.simantics.g2d.diagram.participant.pointertool.TerminalUtil;
import org.simantics.g2d.element.ElementHints;
import org.simantics.g2d.element.handler.TerminalData;
import org.simantics.g2d.tooltip.BaseTooltipParticipant;
import org.simantics.scenegraph.g2d.events.EventHandlerReflection;
import org.simantics.scenegraph.g2d.events.MouseEvent;
import org.simantics.utils.datastructures.hints.IHintContext;

public class TerminalTooltipParticipant
extends BaseTooltipParticipant {
    public static final IHintContext.Key KEY_TOOLTIP_TEXT = new IHintContext.KeyOf(String.class, "TERMINAL_TOOLTIP_TEXT");
    @DependencyReflection.Dependency
    PointerInteractor interactor;

    @EventHandlerReflection.EventHandler(priority=0)
    public boolean handleMove(MouseEvent.MouseMovedEvent me) {
        this.update(me.controlPosition);
        return false;
    }

    private void update(Point2D controlPos) {
        TerminalUtil.TerminalInfo info = this.interactor.pickTerminal(controlPos);
        if (info != null) {
            TerminalData data = info.e.getElementClass().getAtMostOneItemOfClass(TerminalData.class);
            if (data == null) {
                return;
            }
            String text = (String)data.getHint(info.e, info.t, ElementHints.KEY_TEXT);
            info.e.setHint(KEY_TOOLTIP_TEXT, text);
            this.showTooltipFor(info.e);
        } else {
            this.hideTooltip();
        }
    }
}

