/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.g2d.tooltip;

import java.awt.Frame;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.Rectangle;
import javax.swing.SwingUtilities;
import org.simantics.g2d.element.IElement;
import org.simantics.g2d.tooltip.TooltipProvider;

public abstract class AWTTooltipProvider
implements TooltipProvider {
    private Frame frame;

    public abstract void constructPopup(Frame var1, IElement var2);

    @Override
    public void showTooltip(final IElement element, final int x, final int y) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                if (AWTTooltipProvider.this.frame != null) {
                    AWTTooltipProvider.this.frame.setVisible(false);
                    AWTTooltipProvider.this.frame.dispose();
                    AWTTooltipProvider.this.frame = null;
                }
                AWTTooltipProvider.this.frame = new Frame();
                AWTTooltipProvider.this.frame.setFocusableWindowState(false);
                AWTTooltipProvider.this.frame.setUndecorated(true);
                AWTTooltipProvider.this.constructPopup(AWTTooltipProvider.this.frame, element);
                AWTTooltipProvider.this.frame.pack();
                AWTTooltipProvider.this.setTooltipPosition(x, y);
                AWTTooltipProvider.this.frame.setVisible(true);
            }
        });
    }

    private void setTooltipPosition(int x, int y) {
        GraphicsEnvironment ge = GraphicsEnvironment.getLocalGraphicsEnvironment();
        GraphicsDevice[] graphicsDeviceArray = ge.getScreenDevices();
        int n = graphicsDeviceArray.length;
        int n2 = 0;
        while (n2 < n) {
            GraphicsDevice gd = graphicsDeviceArray[n2];
            Rectangle r = gd.getDefaultConfiguration().getBounds();
            if (r.contains(x, y)) {
                Rectangle ttr = new Rectangle(x, y, this.frame.getWidth(), this.frame.getHeight());
                ttr.y += 24;
                if (!r.contains(ttr)) {
                    ttr.y = Math.max(r.y, ttr.y);
                    ttr.y = Math.min(r.y + r.height, ttr.y + ttr.height) - ttr.height;
                    ttr.x = Math.max(r.x, ttr.x);
                    ttr.x = Math.min(r.x + r.width, ttr.x + ttr.width) - ttr.width;
                }
                this.frame.setLocation(ttr.x, ttr.y);
                return;
            }
            ++n2;
        }
    }

    @Override
    public void hideTooltip(IElement element) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                AWTTooltipProvider.this.frame.setVisible(false);
                AWTTooltipProvider.this.frame.dispose();
                AWTTooltipProvider.this.frame = null;
            }
        });
    }
}

