/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.g2d.routing.test;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.RenderingHints;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import org.simantics.g2d.routing.algorithm1.Penalty;
import org.simantics.g2d.routing.algorithm1.Rectangle;
import org.simantics.g2d.routing.algorithm1.StopSet;

public class TestStopSet
extends Frame {
    private static final long serialVersionUID = 2181877722124429003L;
    Collection<Rectangle> rectangles = new ArrayList<Rectangle>();
    Rectangle source;
    Rectangle target;
    double startX;
    double startY;
    double curX;
    double curY;
    int mouseButtons = 0;
    public final double PADDING = 2.0;
    Image offScreenImage;
    int offScreenImageWidth;
    int offScreenImageHeight;

    public TestStopSet() {
        this.addWindowListener(new WindowListener(){

            @Override
            public void windowActivated(WindowEvent e) {
            }

            @Override
            public void windowClosed(WindowEvent e) {
            }

            @Override
            public void windowClosing(WindowEvent e) {
                System.exit(0);
            }

            @Override
            public void windowDeactivated(WindowEvent e) {
            }

            @Override
            public void windowDeiconified(WindowEvent e) {
            }

            @Override
            public void windowIconified(WindowEvent e) {
            }

            @Override
            public void windowOpened(WindowEvent e) {
            }
        });
        this.addMouseListener(new MouseListener(){

            @Override
            public void mouseClicked(MouseEvent e) {
            }

            @Override
            public void mouseEntered(MouseEvent e) {
            }

            @Override
            public void mouseExited(MouseEvent e) {
            }

            @Override
            public void mousePressed(MouseEvent e) {
                TestStopSet.this.mouseButtons = e.getButton();
                TestStopSet.this.curX = TestStopSet.this.startX = (double)e.getX();
                TestStopSet.this.curY = TestStopSet.this.startY = (double)e.getY();
                if (e.getButton() == 2) {
                    TestStopSet.this.source = null;
                } else if (e.getButton() == 3) {
                    TestStopSet.this.target = null;
                }
                TestStopSet.this.repaint();
            }

            @Override
            public void mouseReleased(MouseEvent e) {
                double temp;
                TestStopSet.this.mouseButtons = 0;
                double x0 = TestStopSet.this.startX;
                double y0 = TestStopSet.this.startY;
                double x1 = e.getX();
                double y1 = e.getY();
                if (x0 > x1) {
                    temp = x0;
                    x0 = x1;
                    x1 = temp;
                }
                if (y0 > y1) {
                    temp = y0;
                    y0 = y1;
                    y1 = temp;
                }
                Rectangle rect = new Rectangle(x0, y0, x1, y1);
                if (e.getButton() == 1) {
                    TestStopSet.this.rectangles.add(rect);
                } else if (e.getButton() == 2) {
                    TestStopSet.this.source = rect;
                } else if (e.getButton() == 3) {
                    TestStopSet.this.target = rect;
                }
                TestStopSet.this.repaint();
            }
        });
        this.addMouseMotionListener(new MouseMotionListener(){

            @Override
            public void mouseDragged(MouseEvent e) {
                TestStopSet.this.curX = e.getX();
                TestStopSet.this.curY = e.getY();
                TestStopSet.this.repaint();
            }

            @Override
            public void mouseMoved(MouseEvent e) {
            }
        });
        this.setSize(640, 480);
        this.setVisible(true);
    }

    @Override
    public void paint(Graphics _g) {
        Graphics2D g = (Graphics2D)_g;
        HashMap<RenderingHints.Key, Object> hints = new HashMap<RenderingHints.Key, Object>();
        hints.put(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        hints.put(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
        g.addRenderingHints(hints);
        g.setColor(Color.GRAY);
        g.setStroke(new BasicStroke(1.0f));
        for (Rectangle rect : this.rectangles) {
            TestStopSet.drawRectangle(g, rect.x0, rect.y0, rect.x1, rect.y1);
        }
        if (this.source != null) {
            g.setColor(Color.BLUE);
            TestStopSet.drawRectangle(g, this.source.x0, this.source.y0, this.source.x1, this.source.y1);
        }
        if (this.target != null) {
            g.setColor(Color.GREEN);
            TestStopSet.drawRectangle(g, this.target.x0, this.target.y0, this.target.x1, this.target.y1);
        }
        if (this.mouseButtons != 0) {
            if (this.mouseButtons == 1) {
                g.setColor(Color.BLACK);
            } else if (this.mouseButtons == 2) {
                g.setColor(Color.BLUE);
            } else if (this.mouseButtons == 3) {
                g.setColor(Color.GREEN);
            }
            TestStopSet.drawRectangle(g, this.startX, this.startY, this.curX, this.curY);
        }
        ArrayList<StopSet.Stop> stops = new ArrayList<StopSet.Stop>(this.rectangles.size());
        Penalty penalty = new Penalty(100.0, 0.0);
        for (Rectangle rect : this.rectangles) {
            stops.add(new StopSet.Stop(penalty, rect.x0, rect.x1, rect.y0));
        }
        StopSet ss = new StopSet(stops);
        if (this.target != null) {
            g.setColor(Color.GREEN);
            g.setStroke(new BasicStroke(1.0f));
            this.drawFront(g, ss, this.target.x0, this.target.x1, this.target.y1);
        }
    }

    void drawFront(final Graphics2D g, final StopSet ss, final double x0, final double x1, final double y) {
        ss.findStops(x0, x1, y, new StopSet.IStopProcedure(){

            @Override
            public void blockEnd(double y1) {
                if (y1 == Double.POSITIVE_INFINITY) {
                    y1 = 100000.0;
                }
                Rectangle2D.Double rect = new Rectangle2D.Double(x0 + 2.0, y + 2.0, x1 - x0 - 4.0, y1 - y - 4.0);
                g.draw(rect);
            }

            @Override
            public void continuation(double min, double max, int pos, StopSet.Line line) {
                TestStopSet.this.drawFront(g, ss, pos, line, min, max);
            }
        });
    }

    void drawFront(final Graphics2D g, final StopSet ss, int pos, final StopSet.Line line, final double x0, final double x1) {
        StopSet.continueStop(pos, line, x0, x1, new StopSet.IStopProcedure(){

            @Override
            public void blockEnd(double y1) {
                if (y1 == Double.POSITIVE_INFINITY) {
                    y1 = 100000.0;
                }
                Rectangle2D.Double rect = new Rectangle2D.Double(x0 + 2.0, line.y + 2.0, x1 - x0 - 4.0, y1 - line.y - 4.0);
                g.draw(rect);
            }

            @Override
            public void continuation(double min, double max, int pos, StopSet.Line line2) {
                TestStopSet.this.drawFront(g, ss, pos, line2, min, max);
            }
        });
    }

    static void drawRectangle(Graphics2D g, double x0, double y0, double x1, double y1) {
        double temp;
        if (x0 > x1) {
            temp = x0;
            x0 = x1;
            x1 = temp;
        }
        if (y0 > y1) {
            temp = y0;
            y0 = y1;
            y1 = temp;
        }
        Rectangle2D.Double rect = new Rectangle2D.Double(x0, y0, x1 - x0, y1 - y0);
        g.fill(rect);
    }

    @Override
    public void update(Graphics g) {
        if (this.offScreenImage == null || this.getWidth() != this.offScreenImageWidth || this.getHeight() != this.offScreenImageHeight) {
            this.offScreenImageWidth = this.getWidth();
            this.offScreenImageHeight = this.getHeight();
            this.offScreenImage = this.createImage(this.offScreenImageWidth, this.offScreenImageHeight);
        }
        Graphics gOffScreenImage = this.offScreenImage.getGraphics();
        gOffScreenImage.clearRect(0, 0, this.getWidth(), this.getHeight());
        this.paint(gOffScreenImage);
        g.drawImage(this.offScreenImage, 0, 0, this);
        gOffScreenImage.dispose();
    }

    public static void main(String[] args) {
        new TestStopSet();
    }
}

