/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.g2d.routing.test;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.RenderingHints;
import java.awt.Stroke;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.awt.geom.Ellipse2D;
import java.awt.geom.Path2D;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import org.simantics.g2d.routing.Connection;
import org.simantics.g2d.routing.Obstacle;
import org.simantics.g2d.routing.algorithm1.RouterOld;

public class TestRouter
extends Frame {
    private static final long serialVersionUID = 2181877722124429003L;
    List<Obstacle> obstacles = new ArrayList<Obstacle>();
    List<Connection> connections = new ArrayList<Connection>();
    Connection connection;
    RouterOld router = new RouterOld();
    double startX;
    double startY;
    double curX;
    double curY;
    int mouseButtons = 0;
    static final Stroke stroke1 = new BasicStroke(1.0f);
    static final Stroke stroke3 = new BasicStroke(3.0f);
    static final Stroke stroke5 = new BasicStroke(5.0f);
    Image offScreenImage;
    int offScreenImageWidth;
    int offScreenImageHeight;

    public TestRouter() {
        this.addWindowListener(new WindowListener(){

            @Override
            public void windowActivated(WindowEvent e) {
            }

            @Override
            public void windowClosed(WindowEvent e) {
            }

            @Override
            public void windowClosing(WindowEvent e) {
                System.exit(0);
            }

            @Override
            public void windowDeactivated(WindowEvent e) {
            }

            @Override
            public void windowDeiconified(WindowEvent e) {
            }

            @Override
            public void windowIconified(WindowEvent e) {
            }

            @Override
            public void windowOpened(WindowEvent e) {
            }
        });
        this.addMouseListener(new MouseListener(){

            @Override
            public void mouseClicked(MouseEvent e) {
            }

            @Override
            public void mouseEntered(MouseEvent e) {
            }

            @Override
            public void mouseExited(MouseEvent e) {
            }

            @Override
            public void mousePressed(MouseEvent e) {
                TestRouter.this.mouseButtons = e.getButton();
                TestRouter.this.curX = TestRouter.this.startX = (double)e.getX();
                TestRouter.this.curY = TestRouter.this.startY = (double)e.getY();
                if (e.getButton() == 3) {
                    if (TestRouter.this.connection == null) {
                        TestRouter.this.connection = new Connection(new double[0], 15, 15);
                    }
                    TestRouter.this.connection.routePath = Arrays.copyOf(TestRouter.this.connection.routePath, TestRouter.this.connection.routePath.length + 2);
                    TestRouter.this.connection.routePath[TestRouter.this.connection.routePath.length - 2] = TestRouter.this.curX;
                    TestRouter.this.connection.routePath[TestRouter.this.connection.routePath.length - 1] = TestRouter.this.curY;
                }
                TestRouter.this.repaint();
            }

            @Override
            public void mouseReleased(MouseEvent e) {
                TestRouter.this.mouseButtons = 0;
                if (e.getButton() == 1) {
                    double temp;
                    double x0 = TestRouter.this.startX;
                    double y0 = TestRouter.this.startY;
                    double x1 = e.getX();
                    double y1 = e.getY();
                    if (x0 > x1) {
                        temp = x0;
                        x0 = x1;
                        x1 = temp;
                    }
                    if (y0 > y1) {
                        temp = y0;
                        y0 = y1;
                        y1 = temp;
                    }
                    Obstacle obs = new Obstacle(new Rectangle2D.Double(x0, y0, x1 - x0, y1 - y0));
                    TestRouter.this.obstacles.add(obs);
                    TestRouter.this.router.addObstacle(obs);
                }
                TestRouter.this.repaint();
            }
        });
        this.addMouseMotionListener(new MouseMotionListener(){

            @Override
            public void mouseDragged(MouseEvent e) {
                TestRouter.this.curX = e.getX();
                TestRouter.this.curY = e.getY();
                TestRouter.this.repaint();
            }

            @Override
            public void mouseMoved(MouseEvent e) {
                TestRouter.this.curX = e.getX();
                TestRouter.this.curY = e.getY();
                if (TestRouter.this.connection != null) {
                    TestRouter.this.repaint();
                }
            }
        });
        this.addKeyListener(new KeyListener(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (e.getKeyChar() == 'c') {
                    if (TestRouter.this.connection != null) {
                        TestRouter.this.connection.routePath = Arrays.copyOf(TestRouter.this.connection.routePath, TestRouter.this.connection.routePath.length + 2);
                        TestRouter.this.connection.routePath[TestRouter.this.connection.routePath.length - 2] = TestRouter.this.curX;
                        TestRouter.this.connection.routePath[TestRouter.this.connection.routePath.length - 1] = TestRouter.this.curY;
                        TestRouter.this.connections.add(TestRouter.this.connection);
                        TestRouter.this.router.addConnection(TestRouter.this.connection);
                    }
                    TestRouter.this.connection = null;
                    TestRouter.this.repaint();
                }
            }

            @Override
            public void keyReleased(KeyEvent e) {
            }

            @Override
            public void keyTyped(KeyEvent e) {
            }
        });
        this.setSize(640, 480);
        this.setVisible(true);
    }

    @Override
    public void paint(Graphics _g) {
        Graphics2D g = (Graphics2D)_g;
        HashMap<RenderingHints.Key, Object> hints = new HashMap<RenderingHints.Key, Object>();
        hints.put(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        hints.put(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
        g.addRenderingHints(hints);
        g.setColor(Color.GRAY);
        g.setStroke(new BasicStroke(1.0f));
        for (Obstacle obs : this.obstacles) {
            g.fill(obs.shape);
        }
        Obstacle curObs = null;
        if (this.mouseButtons == 1) {
            double temp;
            double x0 = this.startX;
            double y0 = this.startY;
            double x1 = this.curX;
            double y1 = this.curY;
            if (x0 > x1) {
                temp = x0;
                x0 = x1;
                x1 = temp;
            }
            if (y0 > y1) {
                temp = y0;
                y0 = y1;
                y1 = temp;
            }
            curObs = new Obstacle(new Rectangle2D.Double(x0, y0, x1 - x0, y1 - y0));
            g.fill(curObs.shape);
            this.router.addObstacle(curObs);
        }
        Connection curConnection = null;
        if (this.connection != null) {
            double[] points = Arrays.copyOf(this.connection.routePath, this.connection.routePath.length + 2);
            points[points.length - 2] = this.curX;
            points[points.length - 1] = this.curY;
            curConnection = new Connection(points, this.connection.startDirections, this.connection.endDirections);
            this.router.addConnection(curConnection);
        }
        g.setColor(Color.BLACK);
        g.setStroke(new BasicStroke(3.0f));
        for (Connection c : this.connections) {
            this.draw(g, c);
        }
        if (curConnection != null) {
            this.draw(g, curConnection);
            this.router.removeConnection(curConnection);
        }
        if (curObs != null) {
            this.router.removeObstacle(curObs);
        }
    }

    public void draw(Graphics2D g, Connection c) {
        Path2D path = this.router.getPath(c);
        if (path == null) {
            return;
        }
        g.setColor(Color.WHITE);
        g.setStroke(stroke5);
        g.draw(path);
        g.setColor(Color.BLACK);
        g.setStroke(stroke1);
        g.draw(path);
        double[] points = c.routePath;
        int i = 0;
        while (i < points.length) {
            double x = points[i];
            double y = points[i + 1];
            g.setStroke(stroke1);
            g.draw(new Ellipse2D.Double(x - 5.0, y - 5.0, 10.0, 10.0));
            i += 2;
        }
    }

    static void drawRectangle(Graphics2D g, double x0, double y0, double x1, double y1) {
        double temp;
        if (x0 > x1) {
            temp = x0;
            x0 = x1;
            x1 = temp;
        }
        if (y0 > y1) {
            temp = y0;
            y0 = y1;
            y1 = temp;
        }
        Rectangle2D.Double rect = new Rectangle2D.Double(x0 += 5.0, y0 += 5.0, (x1 -= 5.0) - x0, (y1 -= 5.0) - y0);
        g.fill(rect);
    }

    @Override
    public void update(Graphics g) {
        if (this.offScreenImage == null || this.getWidth() != this.offScreenImageWidth || this.getHeight() != this.offScreenImageHeight) {
            this.offScreenImageWidth = this.getWidth();
            this.offScreenImageHeight = this.getHeight();
            this.offScreenImage = this.createImage(this.offScreenImageWidth, this.offScreenImageHeight);
        }
        Graphics gOffScreenImage = this.offScreenImage.getGraphics();
        gOffScreenImage.clearRect(0, 0, this.getWidth(), this.getHeight());
        this.paint(gOffScreenImage);
        g.drawImage(this.offScreenImage, 0, 0, this);
        gOffScreenImage.dispose();
    }

    public static void main(String[] args) {
        new TestRouter();
    }
}

