/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.g2d.routing.algorithm1;

import java.awt.geom.Path2D;
import org.simantics.g2d.routing.algorithm1.Direction;
import org.simantics.g2d.routing.algorithm1.Rectangle;

public class RoutePencil
extends Rectangle {
    public final Direction direction;
    public final RoutePencil parent;
    public double penalty;
    public double distanceConstant;
    public double distanceX;
    public double distanceY;

    public RoutePencil(double x0, double y0, double x1, double y1, double penalty, Direction direction, RoutePencil parent) {
        super(x0, y0, x1, y1);
        this.penalty = penalty;
        this.direction = direction;
        this.parent = parent;
        if (parent == null) {
            this.distanceConstant = 0.0;
            this.distanceX = 0.0;
            this.distanceY = 0.0;
        } else {
            switch (direction.getId()) {
                case 0: {
                    this.distanceX = 1.0;
                    this.distanceY = parent.distanceY;
                    double x = Math.min(parent.x1, x0);
                    this.distanceConstant = parent.distanceConstant + x * (parent.distanceX - this.distanceX);
                    break;
                }
                case 1: {
                    this.distanceX = parent.distanceX;
                    this.distanceY = 1.0;
                    double y = Math.min(parent.y1, y0);
                    this.distanceConstant = parent.distanceConstant + y * (parent.distanceY - this.distanceY);
                    break;
                }
                case 2: {
                    this.distanceX = -1.0;
                    this.distanceY = parent.distanceY;
                    double x = Math.max(parent.x0, x1);
                    this.distanceConstant = parent.distanceConstant + x * (parent.distanceX - this.distanceX);
                    break;
                }
                case 3: {
                    this.distanceX = parent.distanceX;
                    this.distanceY = -1.0;
                    double y = Math.max(parent.y0, y1);
                    this.distanceConstant = parent.distanceConstant + y * (parent.distanceY - this.distanceY);
                }
            }
        }
    }

    double distance(double x, double y) {
        double result = this.distanceConstant;
        result = x < this.x0 ? (result += this.distanceX * this.x0 + (this.x0 - x)) : (x > this.x1 ? (result += this.distanceX * this.x1 + (x - this.x1)) : (result += this.distanceX * x));
        result = y < this.y0 ? (result += this.distanceY * this.y0 + (this.y0 - y)) : (x > this.x1 ? (result += this.distanceY * this.y1 + (y - this.y1)) : (result += this.distanceY * y));
        return result;
    }

    double distance() {
        return this.distanceConstant + this.distanceX * this.x0 + this.distanceY * this.y0;
    }

    void createPath(Path2D path, double x, double y) {
        if (this.parent == null) {
            path.moveTo(RoutePencil.makeFinite(x), RoutePencil.makeFinite(y));
        } else if (this.parent.contains(x, y)) {
            this.parent.createPath(path, x, y);
        } else {
            switch (this.direction.getId()) {
                case 0: {
                    if (this.parent.distanceX < 1.0) {
                        this.parent.createPath(path, this.parent.x1, y);
                        break;
                    }
                    this.parent.createPath(path, (this.parent.x0 + this.parent.x1) * 0.5, y);
                    break;
                }
                case 1: {
                    if (this.parent.distanceY < 1.0) {
                        this.parent.createPath(path, x, this.parent.y1);
                        break;
                    }
                    this.parent.createPath(path, x, (this.parent.y0 + this.parent.y1) * 0.5);
                    break;
                }
                case 2: {
                    if (this.parent.distanceX > -1.0) {
                        this.parent.createPath(path, this.parent.x0, y);
                        break;
                    }
                    this.parent.createPath(path, (this.parent.x0 + this.parent.x1) * 0.5, y);
                    break;
                }
                case 3: {
                    if (this.parent.distanceY > -1.0) {
                        this.parent.createPath(path, x, this.parent.y0);
                        break;
                    }
                    this.parent.createPath(path, x, (this.parent.y0 + this.parent.y1) * 0.5);
                }
            }
            path.lineTo(RoutePencil.makeFinite(x), RoutePencil.makeFinite(y));
        }
    }

    static double makeFinite(double x) {
        if (x == Double.POSITIVE_INFINITY) {
            return 10000.0;
        }
        if (x == Double.NEGATIVE_INFINITY) {
            return -10000.0;
        }
        return x;
    }

    public Path2D createPath(double x, double y) {
        Path2D.Double path = new Path2D.Double();
        this.createPath(path, x, y);
        return path;
    }

    @Override
    public String toString() {
        if (this.parent == null) {
            return Integer.toString(this.direction.getId());
        }
        return this.parent.toString() + " " + Integer.toString(this.direction.getId());
    }
}

