/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.g2d.routing;

import java.awt.geom.Rectangle2D;
import java.util.Arrays;
import org.simantics.g2d.routing.IConnection;
import org.simantics.g2d.routing.Terminal;

public class ConnectionDirectionUtil {
    public static Terminal createTerminal(Rectangle2D shape, double x, double y) {
        Object[] dirs = new Dir[]{new Dir(0, shape.getMaxX() - x), new Dir(1, shape.getMaxY() - y), new Dir(2, x - shape.getMinX()), new Dir(3, y - shape.getMinY())};
        Arrays.sort(dirs);
        double[] dist = new double[4];
        int flags = 0;
        int i = 0;
        do {
            flags |= 1 << ((Dir)dirs[i]).id;
            dist[((Dir)dirs[i]).id] = Math.max(0.0, ((Dir)dirs[i]).dist + 1.0E-6);
        } while (++i < 4 && (((Dir)dirs[i]).dist <= 0.0 || ((Dir)dirs[i]).dist * 0.9 < ((Dir)dirs[0]).dist));
        return new Terminal(x, y, flags, dist, shape);
    }

    public static int reverseDirections(int flags) {
        return ((flags & 1) == 0 ? 0 : 4) | ((flags & 2) == 0 ? 0 : 8) | ((flags & 4) == 0 ? 0 : 1) | ((flags & 8) == 0 ? 0 : 2);
    }

    public static void determineAllowedDirections(IConnection.Connector c) {
        if (c.parentObstacle == null) {
            c.allowedDirections = 15;
            return;
        }
        Object[] dirs = new Dir[]{new Dir(0, c.parentObstacle.getMaxX() - c.x), new Dir(1, c.parentObstacle.getMaxY() - c.y), new Dir(2, c.x - c.parentObstacle.getMinX()), new Dir(3, c.y - c.parentObstacle.getMinY())};
        Arrays.sort(dirs);
        double[] dist = new double[4];
        c.allowedDirections = 0;
        int i = 0;
        do {
            c.allowedDirections |= 1 << ((Dir)dirs[i]).id;
            dist[((Dir)dirs[i]).id] = Math.max(0.0, ((Dir)dirs[i]).dist + 1.0E-6);
        } while (++i < 4 && (((Dir)dirs[i]).id == (((Dir)dirs[0]).id + 2 & 3) && (((Dir)dirs[i]).dist <= 0.0 || ((Dir)dirs[i]).dist * 0.9 < ((Dir)dirs[0]).dist) || ((Dir)dirs[i]).dist <= 0.0 || ((Dir)dirs[i]).dist * 0.95 < ((Dir)dirs[0]).dist));
    }

    public static class Dir
    implements Comparable<Dir> {
        int id;
        double dist;

        public Dir(int id, double dist) {
            this.id = id;
            this.dist = dist;
        }

        @Override
        public int compareTo(Dir o) {
            if (this.dist < o.dist) {
                return -1;
            }
            if (o.dist < this.dist) {
                return 1;
            }
            return 0;
        }
    }
}

