/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.g2d.participant;

import java.awt.GraphicsConfiguration;
import org.simantics.g2d.canvas.ICanvasContext;
import org.simantics.g2d.canvas.impl.AbstractCanvasParticipant;
import org.simantics.g2d.image.Image;
import org.simantics.utils.datastructures.cache.IProvider;
import org.simantics.utils.datastructures.hints.HintContext;
import org.simantics.utils.datastructures.hints.IHintContext;

public class SymbolUtil
extends AbstractCanvasParticipant {
    HintContext hintCtx = new HintContext();

    @Override
    public void removedFromContext(ICanvasContext ctx) {
        this.hintCtx = null;
        super.removedFromContext(ctx);
    }

    public Image get(IProvider<Image> provider, GraphicsConfiguration gc) {
        SymbolKey key = new SymbolKey(gc, provider);
        Image ps = (Image)this.hintCtx.getHint((IHintContext.Key)key);
        if (ps != null) {
            return ps;
        }
        ps = (Image)provider.get();
        this.hintCtx.setHint((IHintContext.Key)key, (Object)ps);
        return ps;
    }

    static class SymbolKey
    extends IHintContext.Key {
        public final IProvider<Image> provider;
        public final GraphicsConfiguration gc;
        private final int hash;

        public SymbolKey(GraphicsConfiguration gc, IProvider<Image> provider) {
            assert (gc != null && provider != null);
            this.gc = gc;
            this.provider = provider;
            this.hash = gc.hashCode() ^ provider.hashCode();
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof SymbolKey)) {
                return false;
            }
            SymbolKey other = (SymbolKey)((Object)obj);
            if (!other.provider.equals(this.provider)) {
                return false;
            }
            return other.gc.equals(this.gc);
        }

        public int hashCode() {
            return this.hash;
        }

        public boolean isValueAccepted(Object value) {
            return value instanceof Image;
        }
    }
}

