/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.g2d.participant;

import org.simantics.g2d.canvas.impl.AbstractCanvasParticipant;
import org.simantics.g2d.canvas.impl.HintReflection;
import org.simantics.scenegraph.INode;
import org.simantics.scenegraph.g2d.G2DSceneGraph;
import org.simantics.scenegraph.g2d.nodes.NavigationNode;
import org.simantics.scenegraph.utils.Quality;
import org.simantics.utils.datastructures.hints.IHintContext;
import org.simantics.utils.datastructures.hints.IHintObservable;

public class RenderingQualityInteractor
extends AbstractCanvasParticipant {
    public static final IHintContext.Key KEY_QUALITY_INTERACTOR_ENABLED = new IHintContext.KeyOf(Boolean.class);
    public static final IHintContext.Key KEY_STATIC_QUALITY = new IHintContext.KeyOf(Quality.class);

    public Quality setStaticQuality(Quality staticQuality) {
        Quality old = (Quality)this.getHint(KEY_STATIC_QUALITY);
        if (staticQuality != null) {
            this.setHint(KEY_STATIC_QUALITY, staticQuality);
        } else {
            this.removeHint(KEY_STATIC_QUALITY);
        }
        return old;
    }

    private void setStaticQuality0(Quality staticQuality) {
        if (!this.isEnabled()) {
            return;
        }
        NavigationNode nav = this.getNavigationNode();
        if (nav == null) {
            return;
        }
        nav.setStaticQualityMode(staticQuality);
        nav.setDynamicQuality(Boolean.valueOf(staticQuality == null));
    }

    public boolean isEnabled() {
        Boolean qualityPaint = (Boolean)this.getHint(KEY_QUALITY_INTERACTOR_ENABLED);
        return !Boolean.FALSE.equals(qualityPaint);
    }

    private NavigationNode getNavigationNode() {
        G2DSceneGraph sg = this.getContext().getSceneGraph();
        INode node = sg.lookupNode("navigation");
        return node instanceof NavigationNode ? (NavigationNode)node : null;
    }

    @HintReflection.HintListener(Class=RenderingQualityInteractor.class, Field="KEY_STATIC_QUALITY")
    public void hintChanged(IHintObservable sender, IHintContext.Key key, Object oldValue, Object newValue) {
        this.setStaticQuality0((Quality)newValue);
    }

    @HintReflection.HintListener(Class=RenderingQualityInteractor.class, Field="KEY_STATIC_QUALITY")
    public void hintRemoved(IHintObservable sender, IHintContext.Key key, Object oldValue) {
        this.setStaticQuality0(null);
    }
}

