/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.g2d.participant;

import java.awt.geom.Rectangle2D;
import org.simantics.g2d.canvas.Hints;
import org.simantics.g2d.canvas.ICanvasContext;
import org.simantics.g2d.canvas.impl.AbstractCanvasParticipant;
import org.simantics.g2d.canvas.impl.SGNodeReflection;
import org.simantics.scenegraph.g2d.G2DParentNode;
import org.simantics.scenegraph.g2d.nodes.PageBorderNode;
import org.simantics.utils.datastructures.hints.HintListenerAdapter;
import org.simantics.utils.datastructures.hints.IHintContext;
import org.simantics.utils.datastructures.hints.IHintListener;
import org.simantics.utils.datastructures.hints.IHintObservable;
import org.simantics.utils.page.MarginUtils;
import org.simantics.utils.page.PageDesc;

public class PageBorderParticipant
extends AbstractCanvasParticipant {
    IHintListener hintListener = new HintListenerAdapter(){

        public void hintChanged(IHintObservable sender, IHintContext.Key key, Object oldValue, Object newValue) {
            if (key == Hints.KEY_PAGE_DESC) {
                PageBorderParticipant.this.updateNode(true);
            } else if (key == Hints.KEY_DISPLAY_PAGE) {
                PageBorderParticipant.this.updateNode(true);
            } else if (key == Hints.KEY_DISPLAY_MARGINS) {
                PageBorderParticipant.this.updateNode(true);
            } else if (key == Hints.KEY_DISABLE_PAINTING) {
                PageBorderParticipant.this.updateNode(true);
            }
        }
    };
    protected PageBorderNode node = null;

    @Override
    public void addedToContext(ICanvasContext ctx) {
        super.addedToContext(ctx);
        this.getHintStack().addKeyHintListener(this.getThread(), Hints.KEY_PAGE_DESC, this.hintListener);
        this.getHintStack().addKeyHintListener(this.getThread(), Hints.KEY_DISPLAY_PAGE, this.hintListener);
        this.getHintStack().addKeyHintListener(this.getThread(), Hints.KEY_DISPLAY_MARGINS, this.hintListener);
        this.getHintStack().addKeyHintListener(this.getThread(), Hints.KEY_DISABLE_PAINTING, this.hintListener);
    }

    @Override
    public void removedFromContext(ICanvasContext ctx) {
        this.getHintStack().removeKeyHintListener(this.getThread(), Hints.KEY_PAGE_DESC, this.hintListener);
        this.getHintStack().removeKeyHintListener(this.getThread(), Hints.KEY_DISPLAY_PAGE, this.hintListener);
        this.getHintStack().removeKeyHintListener(this.getThread(), Hints.KEY_DISPLAY_MARGINS, this.hintListener);
        this.getHintStack().removeKeyHintListener(this.getThread(), Hints.KEY_DISABLE_PAINTING, this.hintListener);
        super.removedFromContext(ctx);
    }

    protected void updateNode(boolean markDirty) {
        boolean displayPage = !Boolean.FALSE.equals(this.getHint(Hints.KEY_DISPLAY_PAGE));
        boolean displayMargins = !Boolean.FALSE.equals(this.getHint(Hints.KEY_DISPLAY_MARGINS));
        boolean enabled = !Boolean.TRUE.equals(this.getHint(Hints.KEY_DISABLE_PAINTING));
        Rectangle2D.Double border = new Rectangle2D.Double();
        Rectangle2D.Double margin = new Rectangle2D.Double();
        PageDesc desc = (PageDesc)this.getHint(Hints.KEY_PAGE_DESC);
        if (desc != null) {
            if (displayPage) {
                desc.getPageRectangle((Rectangle2D)border);
            }
            MarginUtils.Margins margins = desc.getMargins();
            boolean marginsZero = margins.isZero();
            if (displayMargins && !marginsZero) {
                double mlx = desc.getLeftEdgePos() + margins.left.diagramAbsolute;
                double mty = desc.getTopEdgePos() + margins.top.diagramAbsolute;
                double w = desc.getOrientedWidth() - (margins.left.diagramAbsolute + margins.right.diagramAbsolute);
                double h = desc.getOrientedHeight() - (margins.top.diagramAbsolute + margins.bottom.diagramAbsolute);
                margin.setFrame(mlx, mty, w, h);
            }
        }
        this.node.init((Rectangle2D)border, (Rectangle2D)margin, Boolean.valueOf(enabled));
        if (markDirty) {
            this.setDirty();
        }
    }

    @SGNodeReflection.SGInit
    public void initSG(G2DParentNode parent) {
        this.node = (PageBorderNode)parent.addNode("page border", PageBorderNode.class);
        this.node.setZIndex(-1000);
        this.updateNode(false);
    }

    @SGNodeReflection.SGCleanup
    public void cleanupSG() {
        this.node.remove();
    }
}

