/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.g2d.participant;

import java.awt.geom.Point2D;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.simantics.g2d.canvas.Hints;
import org.simantics.g2d.canvas.impl.AbstractCanvasParticipant;
import org.simantics.g2d.canvas.impl.DependencyReflection;
import org.simantics.g2d.canvas.impl.HintReflection;
import org.simantics.g2d.participant.TransformUtil;
import org.simantics.scenegraph.g2d.events.Event;
import org.simantics.scenegraph.g2d.events.EventHandlerReflection;
import org.simantics.scenegraph.g2d.events.MouseEvent;
import org.simantics.utils.datastructures.hints.IHintContext;
import org.simantics.utils.datastructures.hints.IHintObservable;

public class MouseUtil
extends AbstractCanvasParticipant {
    @DependencyReflection.Dependency
    protected TransformUtil util;
    protected Map<Integer, MouseInfo> miceInfo = new HashMap<Integer, MouseInfo>();
    protected Map<Integer, MouseInfo> micePressedInfo = new HashMap<Integer, MouseInfo>();
    protected MouseClickProfile profile = MouseClickProfile.DEFAULT;

    @HintReflection.HintListener(Class=Hints.class, Field="KEY_CANVAS_TRANSFORM")
    public void transformChanged(IHintObservable sender, IHintContext.Key key, Object oldValue, Object newValue) {
        if (oldValue != null && oldValue.equals(newValue)) {
            return;
        }
        this.sendMicePos();
    }

    @EventHandlerReflection.EventHandler(priority=0x7FFFFFFF)
    public boolean handleMouseEvent(MouseEvent e) {
        this.assertDependencies();
        if (e instanceof MouseEvent.MouseEnterEvent) {
            Point2D canvasPosition = this.util.controlToCanvas(e.controlPosition, null);
            MouseInfo mi = new MouseInfo(e.mouseId, e.controlPosition, canvasPosition, e.buttons);
            this.miceInfo.put(e.mouseId, mi);
        } else if (e instanceof MouseEvent.MouseExitEvent) {
            this.miceInfo.remove(e.mouseId);
        } else if (e instanceof MouseEvent.MouseMovedEvent) {
            Point2D canvasPosition = this.util.controlToCanvas(e.controlPosition, null);
            double deltaDistance = 0.0;
            MouseInfo mi = this.miceInfo.get(e.mouseId);
            if (mi == null) {
                mi = new MouseInfo(e.mouseId, e.controlPosition, canvasPosition, 0);
                this.miceInfo.put(e.mouseId, mi);
            } else {
                deltaDistance = e.controlPosition.distance(mi.controlPosition);
                mi.controlPosition = e.controlPosition;
                mi.canvasPosition = canvasPosition;
            }
            if (deltaDistance > 0.0) {
                mi.addDistanceForButtons(deltaDistance);
            }
        } else if (e instanceof MouseEvent.MouseButtonPressedEvent) {
            Point2D canvasPosition = this.util.controlToCanvas(e.controlPosition, null);
            MouseEvent.MouseButtonPressedEvent me = (MouseEvent.MouseButtonPressedEvent)e;
            MouseInfo mi = this.miceInfo.get(e.mouseId);
            if (mi == null) {
                mi = new MouseInfo(e.mouseId, e.controlPosition, canvasPosition, e.buttons);
                this.miceInfo.put(e.mouseId, mi);
                this.micePressedInfo.put(e.mouseId, mi);
            } else {
                mi.controlPosition = e.controlPosition;
                mi.canvasPosition = canvasPosition;
                this.micePressedInfo.put(e.mouseId, new MouseInfo(e.mouseId, e.controlPosition, canvasPosition, e.buttons));
            }
            mi.setButtonPressed(me.button, e.stateMask, e.controlPosition, canvasPosition, e.time);
        } else if (e instanceof MouseEvent.MouseButtonReleasedEvent) {
            MouseEvent.MouseButtonReleasedEvent me = (MouseEvent.MouseButtonReleasedEvent)e;
            Point2D canvasPosition = this.util.controlToCanvas(me.controlPosition, null);
            MouseInfo mi = this.miceInfo.get(me.mouseId);
            if (mi == null) {
                mi = new MouseInfo(e.mouseId, me.controlPosition, canvasPosition, 0);
                this.miceInfo.put(me.mouseId, mi);
            } else {
                mi.controlPosition = me.controlPosition;
                mi.canvasPosition = canvasPosition;
            }
            ButtonInfo bi = mi.releaseButton(me.button, me.time);
            if (bi == null) {
                return false;
            }
            if (me.holdTime > this.profile.clickHoldTimeTolerance) {
                return false;
            }
            if (bi.deltaMotion > this.profile.movementTolerance) {
                return false;
            }
            long timeSinceLastClick = me.time - bi.lastClickEventTime;
            bi.lastClickEventTime = me.time;
            bi.clickCount = timeSinceLastClick > this.profile.consecutiveToleranceTime ? 1 : ++bi.clickCount;
            MouseEvent.MouseClickEvent ce = new MouseEvent.MouseClickEvent((Object)this.getContext(), e.time, e.mouseId, e.buttons, e.stateMask, me.button, bi.clickCount, me.controlPosition, me.screenPosition);
            this.getContext().getEventQueue().queueFirst((Event)ce);
        }
        return false;
    }

    public MouseInfo getMouseInfo(int mouseId) {
        return this.miceInfo.get(mouseId);
    }

    public MouseInfo getMousePressedInfo(int mouseId) {
        return this.micePressedInfo.get(mouseId);
    }

    public ButtonInfo getButtonInfo(int mouseId, int buttonId) {
        MouseInfo mi = this.miceInfo.get(mouseId);
        if (mi == null) {
            return null;
        }
        return mi.getButtonPressInfo(buttonId);
    }

    public Map<Integer, MouseInfo> getMiceInfo() {
        return new HashMap<Integer, MouseInfo>(this.miceInfo);
    }

    public int getMouseCount() {
        return this.miceInfo.size();
    }

    public MouseClickProfile getProfile() {
        return this.profile;
    }

    public void setProfile(MouseClickProfile profile) {
        assert (profile != null);
        this.profile = profile;
    }

    private void sendMicePos() {
        long time = System.currentTimeMillis();
        for (Map.Entry<Integer, MouseInfo> e : this.miceInfo.entrySet()) {
            MouseInfo mi = e.getValue();
            MouseEvent.MouseMovedEvent mme = new MouseEvent.MouseMovedEvent((Object)this.getContext(), time, e.getKey().intValue(), mi.buttons, 0, mi.controlPosition, null);
            this.getContext().getEventQueue().queueEvent((Event)mme);
        }
    }

    public static final class ButtonInfo {
        public Point2D controlPosition;
        public Point2D canvasPosition;
        public final int button;
        public int stateMask;
        public long systemTime;
        public long eventTime;
        public long holdTime;
        public boolean down = false;
        public double deltaMotion = 0.0;
        public int clickCount = 0;
        public long lastClickEventTime = Long.MIN_VALUE;
        public boolean drag = false;

        public ButtonInfo(int button) {
            this.button = button;
        }
    }

    public static class MouseClickProfile {
        public static final MouseClickProfile DEFAULT = new MouseClickProfile();
        public long clickHoldTimeTolerance = 300L;
        public double movementTolerance = 3.5;
        public long consecutiveToleranceTime = 380L;
    }

    public static final class MouseInfo {
        public int mouseId;
        public Point2D controlPosition;
        public Point2D canvasPosition;
        public int buttons;
        public Map<Integer, ButtonInfo> buttonPressInfo = new HashMap<Integer, ButtonInfo>();

        public MouseInfo(int mouseId, Point2D initialControlPos, Point2D initialCanvasPosition, int initialButtonMask) {
            this.mouseId = mouseId;
            this.controlPosition = initialControlPos;
            this.canvasPosition = initialCanvasPosition;
            int buttonId = 0;
            while (initialButtonMask != 0) {
                if ((initialButtonMask & 1) == 1) {
                    this.setButtonPressed(buttonId, 0, initialControlPos, initialCanvasPosition, Long.MIN_VALUE);
                }
                initialButtonMask >>>= 1;
                ++buttonId;
            }
        }

        public boolean isMouseButtonPressed(int buttonId) {
            ButtonInfo bi = this.buttonPressInfo.get(buttonId);
            return bi != null && bi.down;
        }

        private void _countButtonMask() {
            int result = 0;
            for (ButtonInfo pi : this.buttonPressInfo.values()) {
                if (!pi.down) continue;
                result |= 1 << pi.button - 1;
            }
            this.buttons = result;
        }

        public void setButtonPressed(int buttonId, int stateMask, Point2D controlPos, Point2D canvasPos, long eventTime) {
            ButtonInfo bi = this.getOrCreateButtonInfo(buttonId);
            bi.canvasPosition = canvasPos;
            bi.controlPosition = controlPos;
            bi.systemTime = System.currentTimeMillis();
            bi.eventTime = eventTime;
            bi.down = true;
            bi.deltaMotion = 0.0;
            bi.drag = false;
            bi.stateMask = stateMask;
            this._countButtonMask();
        }

        public ButtonInfo releaseButton(int buttonId, long eventTime) {
            ButtonInfo bi = this.getButtonPressInfo(buttonId);
            if (bi == null) {
                return null;
            }
            bi.down = false;
            bi.holdTime = eventTime - bi.eventTime;
            this._countButtonMask();
            return bi;
        }

        ButtonInfo getOrCreateButtonInfo(int buttonId) {
            ButtonInfo bi = this.buttonPressInfo.get(buttonId);
            if (bi == null) {
                bi = new ButtonInfo(buttonId);
            }
            this.buttonPressInfo.put(buttonId, bi);
            return bi;
        }

        public ButtonInfo getButtonPressInfo(int buttonId) {
            return this.buttonPressInfo.get(buttonId);
        }

        public void addDistanceForButtons(double distance) {
            for (ButtonInfo bi : this.buttonPressInfo.values()) {
                if (!bi.down) continue;
                bi.deltaMotion += distance;
            }
        }

        public Collection<ButtonInfo> getButtonInfos() {
            return this.buttonPressInfo.values();
        }
    }
}

