/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.g2d.participant;

import java.awt.Cursor;
import java.awt.geom.Point2D;
import org.simantics.g2d.canvas.ICanvasContext;
import org.simantics.g2d.canvas.IMouseCursorContext;
import org.simantics.g2d.canvas.IMouseCursorHandle;
import org.simantics.g2d.canvas.impl.AbstractCanvasParticipant;
import org.simantics.g2d.canvas.impl.DependencyReflection;
import org.simantics.g2d.participant.KeyUtil;
import org.simantics.g2d.participant.MouseUtil;
import org.simantics.g2d.participant.PanZoomRotateHandler;
import org.simantics.g2d.participant.TransformUtil;
import org.simantics.scenegraph.g2d.events.Event;
import org.simantics.scenegraph.g2d.events.EventHandlerReflection;
import org.simantics.scenegraph.g2d.events.KeyEvent;
import org.simantics.scenegraph.g2d.events.MouseEvent;
import org.simantics.utils.datastructures.hints.IHintContext;

@Deprecated
public class MousePanZoomInteractor
extends AbstractCanvasParticipant {
    @DependencyReflection.Dependency
    TransformUtil util;
    @DependencyReflection.Dependency
    MouseUtil mice;
    @DependencyReflection.Dependency
    KeyUtil keys;
    @DependencyReflection.Dependency
    PanZoomRotateHandler pzr;
    public static final int MOUSE_PAN_PRIORITY = 2147481647;
    public static final int PAN_PRIORITY = 2147482647;
    public static final int ZOOM_PRIORITY = 2147482648;
    public static final Cursor PAN_CURSOR = new Cursor(13);
    public static final Cursor ZOOM_CURSOR = new Cursor(8);
    public static final IHintContext.Key KEY_MOUSE_PAN_ENABLED = new IHintContext.KeyOf(Boolean.class);
    public static final IHintContext.Key KEY_MOUSE_ZOOM_ENABLED = new IHintContext.KeyOf(Boolean.class);
    public static final IHintContext.Key KEY_MOUSE_WHEEL_ZOOM_PAN_ENABLED = new IHintContext.KeyOf(Boolean.class);
    public static final IHintContext.Key KEY_MOUSE_ZOOM_SPEED = new IHintContext.KeyOf(Double.class);
    public static final double DEFAULT_MOUSE_ZOOM_SPEED = 100.0;
    public static final IHintContext.Key KEY_MOUSE_WHEEL_ZOOM_SPEED = new IHintContext.KeyOf(Double.class);
    public static final double DEFAULT_MOUSE_WHEEL_ZOOM_SPEED = 1000.0;
    public static final IHintContext.Key KEY_MOUSE_WHEEL_TRANSLATE_AMOUNT = new IHintContext.KeyOf(Double.class);
    public static final double DEFAULT_MOUSE_WHEEL_TRANSLATE_AMOUNT = 10.0;

    @Override
    public void addedToContext(ICanvasContext ctx) {
        super.addedToContext(ctx);
        this.setHint(KEY_MOUSE_ZOOM_SPEED, 100.0);
        this.setHint(KEY_MOUSE_ZOOM_ENABLED, true);
        this.setHint(KEY_MOUSE_PAN_ENABLED, true);
        this.setHint(KEY_MOUSE_WHEEL_ZOOM_PAN_ENABLED, true);
        this.setHint(KEY_MOUSE_WHEEL_ZOOM_SPEED, 1000.0);
        this.setHint(KEY_MOUSE_WHEEL_TRANSLATE_AMOUNT, 10.0);
    }

    @EventHandlerReflection.EventHandler(priority=2147481647)
    public boolean handleEvent(MouseEvent e) {
        this.assertDependencies();
        if (e.context instanceof MouseUtil) {
            return false;
        }
        if (e instanceof MouseEvent.MouseButtonPressedEvent && (e.stateMask & 0x40) != 0 && ((MouseEvent.MouseButtonPressedEvent)e).button == 1) {
            return true;
        }
        if (e instanceof MouseEvent.MouseMovedEvent) {
            MouseEvent.MouseMovedEvent mme = (MouseEvent.MouseMovedEvent)e;
            MouseUtil.MouseInfo mi = this.mice.getMouseInfo(mme.mouseId);
            if (mi == null) {
                return false;
            }
            if ((e.stateMask & 0x40) != 0 & mi.isMouseButtonPressed(1)) {
                if (!this.isPanEnabled()) {
                    return false;
                }
                if (!this.isPanning()) {
                    this.getContext().add(new PanMode(mme.mouseId, mme.controlPosition, 1));
                }
                return true;
            }
            if (mi.isMouseButtonPressed(3)) {
                if (!this.isPanEnabled()) {
                    return false;
                }
                if (!this.isPanning()) {
                    this.getContext().add(new PanMode(mme.mouseId, mme.controlPosition, 3));
                }
                return true;
            }
            if ((e.stateMask & 0x40) != 0 & mi.isMouseButtonPressed(2)) {
                if (!this.isZoomEnabled()) {
                    return false;
                }
                if (!this.isZooming()) {
                    Point2D diagramPosition = this.util.getInverseTransform().transform(mme.controlPosition, new Point2D.Double());
                    this.getContext().add(new ZoomMode(mme.mouseId, mme.controlPosition, diagramPosition, 2));
                }
                return true;
            }
        }
        if (e instanceof MouseEvent.MouseWheelMovedEvent) {
            if (!this.isMouseWheelZoomPanEnabled()) {
                return false;
            }
            MouseEvent.MouseWheelMovedEvent we = (MouseEvent.MouseWheelMovedEvent)e;
            if (we.scrollType == 0) {
                double dy = we.wheelRotation;
                double zoom = this.getMouseWheelZoomSpeed();
                double base = 1.0 + zoom / 10000.0;
                double scaleFactor = Math.pow(base, dy);
                scaleFactor = this.pzr.limitScaleFactor(scaleFactor);
                this.util.zoomAroundControlPoint(scaleFactor, we.controlPosition);
                return true;
            }
        }
        return false;
    }

    public boolean isPanEnabled() {
        Boolean h = (Boolean)this.getHint(KEY_MOUSE_PAN_ENABLED);
        if (h == null) {
            return false;
        }
        return h;
    }

    public boolean isPanning() {
        return !this.getContext().getItemsByClass(PanMode.class).isEmpty();
    }

    public boolean isZooming() {
        return !this.getContext().getItemsByClass(ZoomMode.class).isEmpty();
    }

    public boolean isZoomEnabled() {
        Boolean h = (Boolean)this.getHint(KEY_MOUSE_ZOOM_ENABLED);
        if (h == null) {
            return false;
        }
        return h;
    }

    public boolean isMouseWheelZoomPanEnabled() {
        Boolean h = (Boolean)this.getHint(KEY_MOUSE_WHEEL_ZOOM_PAN_ENABLED);
        if (h == null) {
            return false;
        }
        return h;
    }

    public double getMouseZoomSpeed() {
        Double h = (Double)this.getHint(KEY_MOUSE_ZOOM_SPEED);
        if (h == null) {
            return 100.0;
        }
        return h;
    }

    public double getMouseWheelZoomSpeed() {
        Double h = (Double)this.getHint(KEY_MOUSE_WHEEL_ZOOM_SPEED);
        if (h == null) {
            return 1000.0;
        }
        return h;
    }

    public double getMouseWheelTranslateAmount() {
        Double h = (Double)this.getHint(KEY_MOUSE_WHEEL_TRANSLATE_AMOUNT);
        if (h == null) {
            return 10.0;
        }
        return h;
    }

    class PanMode
    extends AbstractCanvasParticipant {
        @DependencyReflection.Dependency
        TransformUtil util;
        final int mouseId;
        int releaseButton;
        Point2D mousePos;
        IMouseCursorHandle cursor;

        public PanMode(int mouseId, Point2D mousePos, int releaseButton) {
            this.mouseId = mouseId;
            this.mousePos = new Point2D.Double(mousePos.getX(), mousePos.getY());
            this.releaseButton = releaseButton;
        }

        @Override
        public void addedToContext(ICanvasContext ctx) {
            super.addedToContext(ctx);
            IMouseCursorContext mctx = this.getContext().getMouseCursorContext();
            if (mctx != null) {
                this.cursor = mctx.setCursor(this.mouseId, PAN_CURSOR);
            }
        }

        @EventHandlerReflection.EventHandler(priority=2147482647)
        public boolean handleEvent(Event e) {
            if (e instanceof MouseEvent.MouseButtonReleasedEvent) {
                MouseEvent.MouseButtonReleasedEvent mpe = (MouseEvent.MouseButtonReleasedEvent)e;
                if (mpe.button == this.releaseButton && mpe.mouseId == this.mouseId) {
                    this.remove();
                    return false;
                }
            }
            if (e instanceof KeyEvent.KeyReleasedEvent) {
                KeyEvent.KeyReleasedEvent ke = (KeyEvent.KeyReleasedEvent)e;
                if (ke.keyCode == 16) {
                    this.remove();
                    return false;
                }
            }
            if (e instanceof MouseEvent.MouseMovedEvent) {
                if (e.getContext() instanceof MouseUtil) {
                    return true;
                }
                MouseEvent.MouseMovedEvent mme = (MouseEvent.MouseMovedEvent)e;
                if (mme.mouseId == this.mouseId) {
                    Point2D oldPos = this.mousePos;
                    Point2D newPos = mme.controlPosition;
                    double dx = newPos.getX() - oldPos.getX();
                    double dy = newPos.getY() - oldPos.getY();
                    if (dx == 0.0 && dy == 0.0) {
                        return true;
                    }
                    this.mousePos.setLocation(newPos);
                    this.util.translateWithControlCoordinates(new Point2D.Double(dx, dy));
                    return true;
                }
            }
            return false;
        }

        @Override
        public void removedFromContext(ICanvasContext ctx) {
            if (this.cursor != null) {
                this.cursor.remove();
                this.cursor = null;
            }
            super.removedFromContext(ctx);
        }
    }

    class ZoomMode
    extends AbstractCanvasParticipant {
        final int mouseId;
        int releaseButton;
        Point2D prevMousePos;
        Point2D origControlMousePos;
        Point2D origDiagramMousePos;
        IMouseCursorHandle cursor;

        public ZoomMode(int mouseId, Point2D controlMousePos, Point2D mouseDiagramPos, int releaseButton) {
            this.mouseId = mouseId;
            this.prevMousePos = (Point2D)controlMousePos.clone();
            this.origControlMousePos = (Point2D)controlMousePos.clone();
            this.origDiagramMousePos = (Point2D)mouseDiagramPos.clone();
            this.releaseButton = releaseButton;
        }

        @Override
        public void addedToContext(ICanvasContext ctx) {
            super.addedToContext(ctx);
            IMouseCursorContext mctx = this.getContext().getMouseCursorContext();
            if (mctx != null) {
                this.cursor = mctx.setCursor(this.mouseId, ZOOM_CURSOR);
            }
        }

        @EventHandlerReflection.EventHandler(priority=2147482648)
        public boolean handleEvent(Event e) {
            if (e instanceof MouseEvent.MouseButtonReleasedEvent) {
                MouseEvent.MouseButtonReleasedEvent mpe = (MouseEvent.MouseButtonReleasedEvent)e;
                if (mpe.button == this.releaseButton && mpe.mouseId == this.mouseId) {
                    this.remove();
                    return false;
                }
            }
            if (e instanceof KeyEvent.KeyReleasedEvent) {
                KeyEvent.KeyReleasedEvent ke = (KeyEvent.KeyReleasedEvent)e;
                if (ke.keyCode == 16) {
                    this.remove();
                    return false;
                }
            }
            if (e instanceof MouseEvent.MouseMovedEvent) {
                if (e.getContext() instanceof MouseUtil) {
                    return true;
                }
                MouseEvent.MouseMovedEvent mme = (MouseEvent.MouseMovedEvent)e;
                if (mme.mouseId == this.mouseId) {
                    Point2D oldPos = this.prevMousePos;
                    Point2D newPos = mme.controlPosition;
                    double dy = newPos.getY() - oldPos.getY();
                    this.prevMousePos.setLocation(newPos);
                    double zoomSpeed = MousePanZoomInteractor.this.getMouseZoomSpeed();
                    double base = 1.0 + zoomSpeed / 10000.0;
                    double scaleFactor = Math.pow(base, -dy);
                    scaleFactor = MousePanZoomInteractor.this.pzr.limitScaleFactor(scaleFactor);
                    MousePanZoomInteractor.this.util.zoomAroundDiagramPoint(scaleFactor, this.origDiagramMousePos);
                    return true;
                }
            }
            return false;
        }

        @Override
        public void removedFromContext(ICanvasContext ctx) {
            if (this.cursor != null) {
                this.cursor.remove();
                this.cursor = null;
            }
            super.removedFromContext(ctx);
        }
    }
}

