/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.g2d.participant;

import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;
import org.simantics.g2d.canvas.Hints;
import org.simantics.g2d.canvas.ICanvasContext;
import org.simantics.g2d.canvas.SGDesignation;
import org.simantics.g2d.canvas.impl.AbstractCanvasParticipant;
import org.simantics.g2d.canvas.impl.DependencyReflection;
import org.simantics.g2d.canvas.impl.HintReflection;
import org.simantics.g2d.canvas.impl.SGNodeReflection;
import org.simantics.g2d.participant.TransformUtil;
import org.simantics.g2d.utils.GeometryUtils;
import org.simantics.scenegraph.g2d.G2DParentNode;
import org.simantics.scenegraph.g2d.nodes.BoundsNode;
import org.simantics.utils.datastructures.hints.IHintContext;
import org.simantics.utils.datastructures.hints.IHintObservable;

public class CanvasBoundsParticipant
extends AbstractCanvasParticipant {
    BoundsNode.ResizeListener resizeListener = new BoundsNode.ResizeListener(){

        public void controlResized(Rectangle2D bounds) {
            CanvasBoundsParticipant.this.controlBoundsUpdated(bounds);
        }
    };
    @DependencyReflection.Dependency
    private TransformUtil util;
    private BoundsNode boundsNode = null;
    private Rectangle2D controlBounds = new Rectangle2D.Double();
    private Rectangle2D canvasBounds = new Rectangle2D.Double();

    @HintReflection.HintListener(Class=Hints.class, Field="KEY_CANVAS_TRANSFORM")
    public void selectionChanged(IHintObservable sender, IHintContext.Key key, Object oldValue, Object newValue) {
        AffineTransform inv = this.util.getInverseTransform((AffineTransform)newValue);
        if (inv != null) {
            this.canvasTransformUpdated(this.controlBounds, inv);
        }
    }

    @Override
    public void addedToContext(ICanvasContext ctx) {
        super.addedToContext(ctx);
        IHintContext hctx = ctx.getDefaultHintContext();
        hctx.setHint(Hints.KEY_CONTROL_BOUNDS, (Object)this.controlBounds);
        hctx.setHint(Hints.KEY_CANVAS_BOUNDS, (Object)this.canvasBounds);
    }

    @SGNodeReflection.SGInit(designation=SGDesignation.CONTROL)
    public void initSG(G2DParentNode parent) {
        this.boundsNode = (BoundsNode)parent.addNode("canvasBounds", BoundsNode.class);
        this.boundsNode.setZIndex(Integer.MIN_VALUE);
        this.boundsNode.setResizeListener(this.resizeListener);
    }

    @SGNodeReflection.SGCleanup
    public void cleanupSG() {
        if (this.boundsNode != null) {
            this.boundsNode.setResizeListener(null);
            this.boundsNode.remove();
            this.boundsNode = null;
        }
    }

    private void controlBoundsUpdated(Rectangle2D bounds) {
        AffineTransform invTr;
        if (!this.controlBounds.equals(bounds)) {
            this.setControlBounds(bounds.getBounds());
        }
        if ((invTr = this.util.getInverseTransform()) != null) {
            this.canvasTransformUpdated(this.controlBounds, invTr);
        }
    }

    private void canvasTransformUpdated(Rectangle2D controlBounds, AffineTransform inverseViewTr) {
        Shape shape = GeometryUtils.transformShape(controlBounds, inverseViewTr);
        Rectangle2D visibleCanvasBounds = shape.getBounds2D();
        if (!this.canvasBounds.equals(visibleCanvasBounds)) {
            this.setCanvasBounds(visibleCanvasBounds);
        }
    }

    private void setControlBounds(Rectangle bounds) {
        this.controlBounds = bounds;
        IHintContext ctx = this.getContext().getDefaultHintContext();
        ctx.setHint(Hints.KEY_CONTROL_BOUNDS, (Object)this.controlBounds);
    }

    private void setCanvasBounds(Rectangle2D bounds) {
        this.canvasBounds = bounds;
        IHintContext ctx = this.getContext().getDefaultHintContext();
        ctx.setHint(Hints.KEY_CANVAS_BOUNDS, (Object)this.canvasBounds);
    }

    public Rectangle2D getControlBounds() {
        return this.controlBounds;
    }

    public Rectangle2D getCanvasBounds() {
        return this.canvasBounds;
    }
}

