/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.g2d.page;

import org.simantics.utils.page.PageDesc;

public class DiagramDesc {
    private final PageDesc pageDesc;
    private final double gridSize;
    private final boolean pageBordersVisible;
    private final boolean marginsVisible;
    private final boolean gridVisible;
    private final boolean rulerVisible;

    public DiagramDesc(PageDesc pageDesc, double gridSize, boolean pageBordersVisible, boolean marginsVisible, boolean gridVisible, boolean rulerVisible) {
        this.pageDesc = pageDesc;
        this.gridSize = gridSize;
        this.pageBordersVisible = pageBordersVisible;
        this.marginsVisible = marginsVisible;
        this.gridVisible = gridVisible;
        this.rulerVisible = rulerVisible;
    }

    public PageDesc getPageDesc() {
        return this.pageDesc;
    }

    public double getGridSize() {
        return this.gridSize;
    }

    public boolean isPageBordersVisible() {
        return this.pageBordersVisible;
    }

    public boolean isMarginsVisible() {
        return this.marginsVisible;
    }

    public boolean isGridVisible() {
        return this.gridVisible;
    }

    public boolean isRulerVisible() {
        return this.rulerVisible;
    }

    public DiagramDesc withPageDesc(PageDesc pageDesc) {
        return new DiagramDesc(pageDesc, this.gridSize, this.pageBordersVisible, this.marginsVisible, this.gridVisible, this.rulerVisible);
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + (this.pageDesc == null ? 0 : this.pageDesc.hashCode());
        long temp = Double.doubleToLongBits(this.gridSize);
        result = 31 * result + (int)(temp ^ temp >>> 32);
        result = 31 * result + (this.marginsVisible ? 1231 : 1237);
        result = 31 * result + (this.pageBordersVisible ? 1231 : 1237);
        result = 31 * result + (this.gridVisible ? 1231 : 1237);
        result = 31 * result + (this.rulerVisible ? 1231 : 1237);
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        DiagramDesc other = (DiagramDesc)obj;
        if (this.pageDesc == null ? other.pageDesc != null : !this.pageDesc.equals((Object)other.pageDesc)) {
            return false;
        }
        if (Double.doubleToLongBits(this.gridSize) != Double.doubleToLongBits(other.gridSize)) {
            return false;
        }
        if (this.marginsVisible != other.marginsVisible) {
            return false;
        }
        if (this.pageBordersVisible != other.pageBordersVisible) {
            return false;
        }
        if (this.gridVisible != other.gridVisible) {
            return false;
        }
        return this.rulerVisible == other.rulerVisible;
    }

    public String toString() {
        return "[gridSize=" + this.gridSize + ", pageBordersVisible=" + this.pageBordersVisible + ", marginsVisible=" + this.marginsVisible + ", gridVisible=" + this.gridVisible + ", rulerVisible=" + this.rulerVisible + ", pageDesc=" + String.valueOf(this.pageDesc) + "]";
    }
}

