/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.g2d.image.impl;

import java.awt.Shape;
import java.awt.geom.Rectangle2D;
import java.lang.ref.WeakReference;
import java.util.EnumSet;
import org.simantics.g2d.image.Image;
import org.simantics.scenegraph.Node;
import org.simantics.scenegraph.g2d.G2DParentNode;
import org.simantics.utils.datastructures.ListenerList;

public class ImageProxy
implements Image {
    ListenerList<Image.ImageListener> list = null;
    Image source;
    Node node = null;
    WeakImageListener sourceListener;

    public ImageProxy(Image original) {
        if (original == null) {
            throw new IllegalArgumentException("null arg");
        }
        this.source = original;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void notifyChanged() {
        Image.ImageListener[] listeners;
        ImageProxy imageProxy = this;
        synchronized (imageProxy) {
            if (this.list == null) {
                return;
            }
            listeners = (Image.ImageListener[])this.list.getListeners();
        }
        Image.ImageListener[] imageListenerArray = listeners;
        int n = listeners.length;
        int n2 = 0;
        while (n2 < n) {
            Image.ImageListener l = imageListenerArray[n2];
            l.onContentChangedNotification(this);
            ++n2;
        }
    }

    @Override
    public synchronized void addImageListener(Image.ImageListener listener) {
        if (this.list == null) {
            this.list = new ListenerList(Image.ImageListener.class);
        }
        if (this.sourceListener == null) {
            this.sourceListener = new WeakImageListener(this);
            this.source.addImageListener(this.sourceListener);
        }
        this.list.add((Object)listener);
    }

    @Override
    public synchronized void removeImageListener(Image.ImageListener listener) {
        if (this.list == null) {
            return;
        }
        this.list.remove((Object)listener);
        if (this.list.isEmpty()) {
            this.source.removeImageListener(this.sourceListener);
        }
    }

    @Override
    public Rectangle2D getBounds() {
        return this.source.getBounds();
    }

    @Override
    public EnumSet<Image.Feature> getFeatures() {
        return this.source.getFeatures();
    }

    @Override
    public Shape getOutline() {
        return this.source.getOutline();
    }

    @Override
    public Node init(G2DParentNode parent) {
        this.node = this.source.init(parent);
        return this.node;
    }

    public synchronized void setSource(Image newSource) {
        if (newSource == null) {
            throw new IllegalArgumentException("null");
        }
        if (this.source == newSource) {
            return;
        }
        Image oldSource = this.source;
        if (this.node != null) {
            this.node.remove();
            this.node = null;
        }
        this.source = newSource;
        if (this.sourceListener != null) {
            oldSource.removeImageListener(this.sourceListener);
            newSource.addImageListener(this.sourceListener);
        }
        this.notifyChanged();
    }

    static class WeakImageListener
    implements Image.ImageListener {
        WeakReference<ImageProxy> ref;

        public WeakImageListener(ImageProxy img) {
            this.ref = new WeakReference<ImageProxy>(img);
        }

        @Override
        public void onContentChangedNotification(Image image) {
            ImageProxy i = (ImageProxy)this.ref.get();
            if (i == null) {
                image.removeImageListener(this);
            } else {
                i.notifyChanged();
            }
        }
    }
}

