/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.g2d.image;

import java.net.URL;
import org.simantics.g2d.image.Image;
import org.simantics.g2d.image.impl.CacheProvider;
import org.simantics.g2d.image.impl.ImageBundleFactory;
import org.simantics.g2d.image.impl.ImageURLFactory;
import org.simantics.g2d.image.impl.ProviderAsyncronizer;
import org.simantics.g2d.image.impl.ProviderProxier;
import org.simantics.g2d.image.impl.RasterizingProvider;
import org.simantics.utils.datastructures.cache.IFactory;
import org.simantics.utils.datastructures.cache.IProvider;
import org.simantics.utils.datastructures.cache.WeakCachedProvider;

public class ProviderUtils {
    public static IFactory<Image> at(URL url) {
        return new ImageURLFactory(url);
    }

    public static IFactory<Image> bundle(String filename) {
        return new ImageBundleFactory(filename);
    }

    public static IProvider<Image> cache(IProvider<Image> provider) {
        return WeakCachedProvider.cache(provider);
    }

    public static IFactory<Image> rasterize(IProvider<Image> prov) {
        return new RasterizingProvider(prov);
    }

    public static IFactory<Image> asynchronize(IProvider<Image> prov) {
        return new ProviderAsyncronizer(prov);
    }

    public static IFactory<Image> reference(IProvider<Image> prov) {
        return new ProviderProxier(prov);
    }

    public static IProvider<Image> cache(IFactory<Image> prov) {
        return new CacheProvider((IProvider<Image>)prov);
    }

    public static IFactory<Image> convenience(IFactory<Image> originalFactory) {
        return ProviderUtils.reference(ProviderUtils.cache(ProviderUtils.rasterize(ProviderUtils.asynchronize(originalFactory))));
    }

    public static IFactory<Image> convenience(URL url) {
        return ProviderUtils.reference(ProviderUtils.cache(ProviderUtils.rasterize(ProviderUtils.asynchronize(ProviderUtils.at(url)))));
    }

    public static IFactory<Image> convenience(String bundleAddress) {
        return ProviderUtils.reference(ProviderUtils.cache(ProviderUtils.rasterize(ProviderUtils.asynchronize(ProviderUtils.bundle(bundleAddress)))));
    }
}

