/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.g2d.gallery;

import java.awt.Color;
import java.awt.Component;
import java.awt.FontMetrics;
import java.awt.Paint;
import java.awt.Shape;
import java.awt.TexturePaint;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import org.eclipse.jface.resource.FontRegistry;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.jface.viewers.ContentViewer;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Widget;
import org.simantics.g2d.canvas.Hints;
import org.simantics.g2d.canvas.impl.CanvasContext;
import org.simantics.g2d.chassis.SWTChassis;
import org.simantics.g2d.diagram.DiagramClass;
import org.simantics.g2d.diagram.DiagramHints;
import org.simantics.g2d.diagram.IDiagram;
import org.simantics.g2d.diagram.handler.DataElementMap;
import org.simantics.g2d.diagram.handler.PickRequest;
import org.simantics.g2d.diagram.handler.layout.FlowLayout;
import org.simantics.g2d.diagram.impl.Diagram;
import org.simantics.g2d.diagram.participant.DiagramParticipant;
import org.simantics.g2d.diagram.participant.ElementInteractor;
import org.simantics.g2d.diagram.participant.ElementPainter;
import org.simantics.g2d.diagram.participant.Selection;
import org.simantics.g2d.diagram.participant.pointertool.PointerInteractor;
import org.simantics.g2d.dnd.IDragSourceParticipant;
import org.simantics.g2d.dnd.IDropTargetParticipant;
import org.simantics.g2d.element.ElementClass;
import org.simantics.g2d.element.ElementHints;
import org.simantics.g2d.element.ElementUtils;
import org.simantics.g2d.element.IElement;
import org.simantics.g2d.element.handler.Resize;
import org.simantics.g2d.element.handler.impl.DefaultTransform;
import org.simantics.g2d.element.handler.impl.Resizeable;
import org.simantics.g2d.element.handler.impl.TextImpl;
import org.simantics.g2d.element.impl.Element;
import org.simantics.g2d.gallery.GalleryItemSGNode;
import org.simantics.g2d.gallery.GalleryTooltipProvider;
import org.simantics.g2d.gallery.ILabelProvider;
import org.simantics.g2d.image.Image;
import org.simantics.g2d.image.impl.Shadow;
import org.simantics.g2d.participant.BackgroundPainter;
import org.simantics.g2d.participant.KeyToCommand;
import org.simantics.g2d.participant.KeyUtil;
import org.simantics.g2d.participant.MouseUtil;
import org.simantics.g2d.participant.SymbolUtil;
import org.simantics.g2d.participant.TransformUtil;
import org.simantics.g2d.tooltip.ElementTooltipParticipant;
import org.simantics.g2d.tooltip.TooltipParticipant;
import org.simantics.g2d.utils.FontHelper;
import org.simantics.scenegraph.g2d.G2DParentNode;
import org.simantics.scenegraph.g2d.events.command.CommandKeyBinding;
import org.simantics.scenegraph.g2d.nodes.ShapeNode;
import org.simantics.scenegraph.utils.GeometryUtils;
import org.simantics.scenegraph.utils.TextUtil;
import org.simantics.utils.datastructures.hints.IHintContext;
import org.simantics.utils.threads.AWTThread;
import org.simantics.utils.threads.IThreadWorkQueue;
import org.simantics.utils.threads.SWTThread;
import org.simantics.utils.threads.ThreadUtils;
import org.simantics.utils.threads.logger.ITask;
import org.simantics.utils.threads.logger.ThreadLogger;
import org.simantics.utils.ui.SWTDPIUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GalleryViewer
extends ContentViewer {
    private static final Logger LOGGER = LoggerFactory.getLogger(GalleryViewer.class);
    public static final IHintContext.Key KEY_VIEWER = new IHintContext.KeyOf(GalleryViewer.class, "GALLERY_VIEWER");
    public static final Shadow.ShadowParameters SHADOW = new Shadow.ShadowParameters(0.5, Color.BLACK, 5);
    ViewerFilter filter;
    IThreadWorkQueue swtThread;
    Display display;
    SWTChassis chassis;
    Component awtComponent;
    CanvasContext ctx;
    Selection selection;
    GalleryItemPainter itemPainter;
    IDiagram diagram;
    Rectangle2D itemSize = new Rectangle2D.Double(0.0, 0.0, 50.0, 50.0);
    Rectangle2D maxItemSize = this.itemSize.getBounds2D();
    FlowLayout fl = new FlowLayout();
    int hMargin = 5;
    int vMargin = 5;
    ElementClass itemClass;
    FontRegistry fontRegistry;
    java.awt.Font currentItemFont;
    GalleryTooltipProvider tooltipProvider = new GalleryTooltipProvider();
    public static final Paint BG_PAINT;
    IPropertyChangeListener fontRegistryListener = new IPropertyChangeListener(){

        public void propertyChange(PropertyChangeEvent event) {
            FontData fdn = ((FontData[])event.getNewValue())[0];
            GalleryViewer.this.currentItemFont = FontHelper.toAwt(fdn);
            GalleryViewer.this.itemClass.getSingleItem(GalleryItemSGNode.class).setFont(GalleryViewer.this.currentItemFont);
            ThreadUtils.asyncExec((IThreadWorkQueue)GalleryViewer.this.swtThread, () -> GalleryViewer.this.resized(true));
        }
    };
    Image.ImageListener imageListener = new Image.ImageListener(){

        @Override
        public void onContentChangedNotification(Image image) {
            for (IElement el : GalleryViewer.this.diagram.getSnapshot()) {
                Image i = GalleryItemSGNode.getImage(el);
                if (image != i) continue;
                GalleryViewer.this.ctx.getThreadAccess().asyncExec(() -> {
                    if (!GalleryViewer.this.ctx.isDisposed()) {
                        el.getElementClass().getSingleItem(GalleryItemSGNode.class).update(el);
                        GalleryViewer.this.ctx.getContentContext().setDirty();
                    }
                });
                break;
            }
        }
    };

    static {
        BufferedImage bi = new BufferedImage(2, 2, 2);
        int x = 0;
        while (x < 2) {
            int y = 0;
            while (y < 2) {
                bi.setRGB(x, y, ((x ^ y) & 1) == 0 ? -1 : -131587);
                ++y;
            }
            ++x;
        }
        BG_PAINT = new TexturePaint(bi, new Rectangle2D.Double(0.0, 0.0, 10.0, 10.0));
    }

    public GalleryViewer(Composite composite) {
        this(composite, 0);
    }

    public GalleryViewer(Composite composite, int style) {
        this.display = composite.getDisplay();
        this.swtThread = SWTThread.getThreadAccess((Widget)composite);
        this.chassis = new SWTChassis(composite, style){

            public Point computeSize(int wHint, int hHint, boolean changed) {
                if (GalleryViewer.this.diagram == null) {
                    return super.computeSize(wHint, hHint, changed);
                }
                Double wH = wHint == -1 ? null : Double.valueOf((double)SWTDPIUtil.upscaleSwt((int)wHint) - (double)(GalleryViewer.this.hMargin * 2));
                Double hH = hHint == -1 ? null : Double.valueOf((double)SWTDPIUtil.upscaleSwt((int)hHint) - (double)(GalleryViewer.this.vMargin * 2));
                Rectangle2D rect = GalleryViewer.this.fl.computeSize(GalleryViewer.this.diagram, wH, hH);
                SWTDPIUtil.downscaleSwt((Rectangle2D)rect, (Rectangle2D)rect);
                return new Point((int)rect.getWidth() + GalleryViewer.this.hMargin * 2, (int)rect.getHeight() + GalleryViewer.this.vMargin * 2);
            }
        };
        this.diagram = Diagram.spawnNew(DiagramClass.DEFAULT);
        this.diagram.setHint(FlowLayout.HGAP, 5.0);
        this.diagram.setHint(FlowLayout.VGAP, 5.0);
        this.diagram.setHint(DiagramHints.KEY_ELEMENT_RASTER_TARGET_SIZE, new java.awt.Point((int)this.itemSize.getWidth(), (int)this.itemSize.getHeight()));
        this.ctx = new CanvasContext(AWTThread.getThreadAccess());
        this.chassis.populate(parameter -> {
            this.awtComponent = parameter.getAWTComponent();
            ITask task = ThreadLogger.getInstance().begin("createCanvas");
            this.initializeCanvasContext(this.ctx);
            task.finish();
            IHintContext hintCtx = this.ctx.getDefaultHintContext();
            hintCtx.setHint(KEY_VIEWER, (Object)this);
            hintCtx.setHint(DiagramHints.KEY_DIAGRAM, (Object)this.diagram);
            ThreadUtils.asyncExec((IThreadWorkQueue)this.swtThread, () -> this.resized(false));
        });
        this.chassis.addControlListener(new ControlListener(){

            public void controlMoved(ControlEvent e) {
            }

            public void controlResized(ControlEvent e) {
                GalleryViewer.this.resized();
            }
        });
        ITask task2 = ThreadLogger.getInstance().begin("fonts");
        try {
            this.fontRegistry = FontHelper.getCurrentThemeFontRegistry();
            this.fontRegistry.addListener(this.fontRegistryListener);
            this.currentItemFont = FontHelper.toAwt(this.fontRegistry, "org.simantics.gallery.itemfont");
        }
        catch (IllegalStateException illegalStateException) {
            Font f = this.chassis.getFont();
            this.currentItemFont = FontHelper.toAwt(f.getFontData()[0]);
        }
        task2.finish();
        this.itemClass = ElementClass.compile(DefaultTransform.INSTANCE, TextImpl.INSTANCE, Resizeable.UNCONSTRICTED, new GalleryItemSGNode(this.currentItemFont));
        this.chassis.addListener(12, new Listener(){

            public void handleEvent(Event event) {
                if (GalleryViewer.this.fontRegistry != null) {
                    GalleryViewer.this.fontRegistry.removeListener(GalleryViewer.this.fontRegistryListener);
                }
                ThreadUtils.asyncExec((IThreadWorkQueue)GalleryViewer.this.ctx.getThreadAccess(), () -> {
                    GalleryViewer.this.chassis.getAWTComponent().setCanvasContext(null);
                    GalleryViewer.this.ctx.dispose();
                });
            }
        });
    }

    public void setAlign(FlowLayout.Align align) {
        this.diagram.setHint(FlowLayout.ALIGN, (Object)align);
        this.resized();
    }

    public void setFilter(ViewerFilter filter) {
        if (filter == this.filter || filter != null && filter.equals(this.filter)) {
            return;
        }
        this.filter = filter;
    }

    public ViewerFilter getFilter() {
        return this.filter;
    }

    private void resized() {
        this.resized(false);
    }

    private void resized(boolean refreshElementSizes) {
        if (this.chassis.isDisposed()) {
            return;
        }
        Rectangle b = SWTDPIUtil.upscaleSwt((Rectangle)this.chassis.getBounds());
        Rectangle2D.Double bounds = new Rectangle2D.Double(this.hMargin, this.vMargin, b.width - this.hMargin * 2, b.height - this.vMargin * 2);
        this.ctx.getThreadAccess().asyncExec(() -> {
            if (this.ctx.isDisposed()) {
                return;
            }
            if (this.diagram == null) {
                return;
            }
            if (refreshElementSizes) {
                this.refreshElementSizes();
            }
            this.fl.layout(this.diagram, bounds);
            if (this.itemPainter != null) {
                this.itemPainter.updateAll();
            }
            this.ctx.getContentContext().setDirty();
        });
    }

    private void initializeCanvasContext(CanvasContext canvasContext) {
        IHintContext h = canvasContext.getDefaultHintContext();
        canvasContext.add(new TransformUtil());
        canvasContext.add(new MouseUtil());
        canvasContext.add(new KeyUtil());
        canvasContext.add(new SymbolUtil());
        h.setHint(Hints.KEY_BACKGROUND_PAINT, (Object)BG_PAINT);
        canvasContext.add(new BackgroundPainter());
        canvasContext.add(new KeyToCommand(CommandKeyBinding.DEFAULT_BINDINGS));
        PointerInteractor pi = new PointerInteractor(true, true, false, true, false, null);
        pi.setBoxSelectMode(PickRequest.PickPolicy.PICK_INTERSECTING_OBJECTS);
        canvasContext.add(pi);
        this.selection = new Selection();
        canvasContext.add(this.selection);
        canvasContext.add(new DiagramParticipant());
        this.itemPainter = new GalleryItemPainter();
        canvasContext.add(this.itemPainter);
        canvasContext.add(new ElementInteractor());
        canvasContext.add(new ElementTooltipParticipant());
        h.setHint(ElementPainter.KEY_SELECTION_FRAME_COLOR, (Object)Color.WHITE);
        h.setHint(ElementPainter.KEY_SELECTION_CONTENT_COLOR, (Object)new Color(0.7f, 0.7f, 1.0f, 0.5f));
        h.setHint(Hints.KEY_TOOL, (Object)Hints.POINTERTOOL);
        this.chassis.getAWTComponent().setCanvasContext(canvasContext);
        this.swtThread.asyncExec(() -> {
            if (!this.chassis.isDisposed()) {
                this.chassis.setCanvasContext(canvasContext);
            }
        });
        canvasContext.assertParticipantDependencies();
    }

    public Control getControl() {
        return this.chassis;
    }

    protected void inputChanged(Object input, Object oldInput) {
    }

    public ISelection getSelection() {
        Set<IElement> sel = this.selection.getSelection(0);
        if (sel.isEmpty()) {
            return StructuredSelection.EMPTY;
        }
        ArrayList<Object> elements = new ArrayList<Object>(sel.size());
        for (IElement e : sel) {
            elements.add(e.getHint(ElementHints.KEY_OBJECT));
        }
        return new StructuredSelection(elements);
    }

    public void setSelection(ISelection selection, boolean reveal) {
        List selectedObjects = Collections.EMPTY_LIST;
        if (selection instanceof IStructuredSelection) {
            selectedObjects = ((IStructuredSelection)selection).toList();
        }
        DataElementMap map = this.diagram.getDiagramClass().getSingleItem(DataElementMap.class);
        ArrayList<IElement> selectionElements = new ArrayList<IElement>();
        for (Object o : selectedObjects) {
            selectionElements.add(map.getElement(this.diagram, o));
        }
        this.selection.setSelection(0, selectionElements);
    }

    public void refresh() {
        this.refresh(null);
    }

    public Object[] getFilteredElements() {
        IStructuredContentProvider cp = (IStructuredContentProvider)this.getContentProvider();
        if (cp == null) {
            return new Object[0];
        }
        Object[] elements = cp.getElements(this.getInput());
        Object[] filtered = this.filter(elements);
        return filtered;
    }

    protected Object[] filter(Object[] items) {
        if (this.filter != null) {
            ArrayList<Object> filtered = new ArrayList<Object>(items.length);
            Object root = this.getInput();
            int i = 0;
            while (i < items.length) {
                if (this.filter.select((Viewer)this, root, items[i])) {
                    filtered.add(items[i]);
                }
                ++i;
            }
            return filtered.toArray();
        }
        return items;
    }

    public void refresh(Consumer<Object[]> contentCallback) {
        Object[] elements = this.getFilteredElements();
        this.refreshWithContent(elements);
        if (contentCallback != null) {
            contentCallback.accept(elements);
        }
    }

    public void refreshWithContent(final Object[] objects) {
        if (!this.swtThread.currentThreadAccess()) {
            throw new IllegalStateException("Not invoked from SWT thread");
        }
        final Semaphore barrier = new Semaphore(0);
        IThreadWorkQueue t = this.ctx.getThreadAccess();
        ThreadUtils.asyncExec((IThreadWorkQueue)t, (Runnable)new Runnable(){

            @Override
            public void run() {
                try {
                    this.perform();
                }
                finally {
                    barrier.release();
                }
            }

            public void perform() {
                Object[] objectsCopy = Arrays.copyOf(objects, objects.length);
                HashSet<Object> objs = new HashSet<Object>();
                Object[] objectArray = objectsCopy;
                int n = objectsCopy.length;
                int n2 = 0;
                while (n2 < n) {
                    Object o = objectArray[n2];
                    objs.add(o);
                    ++n2;
                }
                for (IElement e : GalleryViewer.this.diagram.getSnapshot()) {
                    Object backendObject = e.getHint(ElementHints.KEY_OBJECT);
                    if (objs.remove(backendObject)) continue;
                    GalleryViewer.this.diagram.removeElement(e);
                }
                int i = 0;
                while (i < objectsCopy.length) {
                    if (!objs.contains(objectsCopy[i])) {
                        objectsCopy[i] = null;
                    }
                    ++i;
                }
                objectArray = objectsCopy;
                n = objectsCopy.length;
                int n3 = 0;
                while (n3 < n) {
                    Object o = objectArray[n3];
                    if (o != null) {
                        IElement e = Element.spawnNew(GalleryViewer.this.itemClass);
                        e.setHint(ElementHints.KEY_OBJECT, o);
                        ILabelProvider lp = (ILabelProvider)GalleryViewer.this.getLabelProvider();
                        Image i2 = lp.getImage(o);
                        if (i2.getFeatures().contains((Object)Image.Feature.Volatile)) {
                            i2.addImageListener(GalleryViewer.this.imageListener);
                        }
                        e.setHint(GalleryItemSGNode.KEY_IMAGE, i2);
                        String tooltipText = lp.getToolTipText(o);
                        java.awt.Image tooltipImage = lp.getToolTipImage(o);
                        if (tooltipText != null || tooltipImage != null) {
                            e.setHint(TooltipParticipant.TOOLTIP_KEY, GalleryViewer.this.tooltipProvider);
                            if (tooltipText != null) {
                                e.setHint(GalleryTooltipProvider.TOOLTIP_TEXT, tooltipText);
                            }
                            if (tooltipImage != null) {
                                e.setHint(GalleryTooltipProvider.TOOLTIP_IMAGE, tooltipImage);
                            }
                        }
                        GalleryViewer.this.diagram.addElement(e);
                        e.getElementClass().getSingleItem(GalleryItemSGNode.class).update(e);
                        ElementUtils.setText(e, lp.getText(o));
                    }
                    ++n3;
                }
                GalleryViewer.this.refreshElementSizes();
                ThreadUtils.asyncExec((IThreadWorkQueue)GalleryViewer.this.swtThread, () -> GalleryViewer.this.resized(false));
            }
        });
        boolean done = false;
        while (!done) {
            try {
                done = barrier.tryAcquire(10L, TimeUnit.MILLISECONDS);
                while (!done && this.display.readAndDispatch()) {
                    done = barrier.tryAcquire();
                }
            }
            catch (InterruptedException interruptedException) {
                done = true;
            }
        }
    }

    void refreshElementSizes() {
        if (this.awtComponent == null) {
            LOGGER.error("GalleryViewer.refreshElementSizes: awtComponent is null");
            return;
        }
        FontMetrics metrics = this.awtComponent.getFontMetrics(this.currentItemFont);
        int fontHeight = metrics.getHeight();
        Rectangle2D size = SWTDPIUtil.upscaleSwt((Rectangle2D)this.itemSize);
        int maxWidth = (int)size.getWidth();
        java.awt.Point targetSize = new java.awt.Point((int)size.getWidth(), (int)size.getHeight());
        this.diagram.setHint(DiagramHints.KEY_ELEMENT_RASTER_TARGET_SIZE, targetSize);
        int maxLinesNeeded = 0;
        for (IElement el : this.diagram.getElements()) {
            el.setHint(GalleryItemSGNode.KEY_TARGET_IMAGE_SIZE, targetSize);
            String text = ElementUtils.getText(el);
            int linesNeeded = TextUtil.wordWrap((String)text, (FontMetrics)metrics, (int)maxWidth).length;
            maxLinesNeeded = Math.max(maxLinesNeeded, linesNeeded);
            int textSpaceNeeded = fontHeight * linesNeeded + metrics.getMaxDescent();
            Rectangle2D.Double s = new Rectangle2D.Double(0.0, 0.0, size.getWidth(), size.getHeight() + (double)textSpaceNeeded);
            el.getElementClass().getSingleItem(Resize.class).resize(el, s);
            el.getElementClass().getSingleItem(GalleryItemSGNode.class).update(el);
        }
        int maxTextSpaceNeeded = fontHeight * maxLinesNeeded + metrics.getMaxDescent();
        this.maxItemSize = new Rectangle2D.Double(0.0, 0.0, size.getWidth(), size.getHeight() + (double)maxTextSpaceNeeded);
    }

    public void addDropSupport(IDropTargetParticipant p) {
        if (this.ctx.getThreadAccess().currentThreadAccess()) {
            this.ctx.add(p);
        } else {
            this.ctx.getThreadAccess().asyncExec(() -> {
                if (!this.ctx.isDisposed()) {
                    this.ctx.add(p);
                }
            });
        }
    }

    public void addDragSupport(IDragSourceParticipant p) {
        if (this.ctx.getThreadAccess().currentThreadAccess()) {
            this.ctx.add(p);
        } else {
            this.ctx.getThreadAccess().asyncExec(() -> {
                if (!this.ctx.isDisposed()) {
                    this.ctx.add(p);
                }
            });
        }
    }

    public CanvasContext getCanvasContext() {
        return this.ctx;
    }

    public IDiagram getDiagram() {
        return this.diagram;
    }

    static class GalleryItemPainter
    extends ElementPainter {
        GalleryItemPainter() {
        }

        @Override
        public void paintSelectionFrame(int selectionId, G2DParentNode elementNode, G2DParentNode selectionNode, IElement e, Color color) {
            Shape outline = ElementUtils.getElementBoundsOnDiagram(e);
            Rectangle2D bounds = outline.getBounds2D();
            GeometryUtils.expandRectangle((Rectangle2D)bounds, (double)2.0, (double)2.0, (double)2.0, (double)2.0);
            ShapeNode shapenode = (ShapeNode)selectionNode.getOrCreateNode("shape_" + e.hashCode(), ShapeNode.class);
            shapenode.setShape((Shape)bounds);
            shapenode.setColor((Paint)new Color(0.3f, 0.3f, 1.0f, 0.25f));
            shapenode.setFill(true);
            selectionNode.setZIndex(Integer.MIN_VALUE);
        }
    }
}

