/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.g2d.event.adapter;

import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.simantics.scenegraph.g2d.events.Event;
import org.simantics.scenegraph.g2d.events.IEventHandler;
import org.simantics.scenegraph.g2d.events.IEventQueue;
import org.simantics.scenegraph.g2d.events.KeyEvent;
import org.simantics.scenegraph.g2d.events.adapter.AbstractEventAdapter;

public class SWTKeyEventAdapter
extends AbstractEventAdapter
implements KeyListener {
    private final boolean DEBUG = false;

    public SWTKeyEventAdapter(Object sender, IEventHandler delegator) {
        super(sender, delegator);
    }

    public SWTKeyEventAdapter(Object sender, IEventQueue queue) {
        super(sender, queue);
    }

    public void keyPressed(KeyEvent e) {
        this.handleEvent((Event)new KeyEvent.KeyPressedEvent(this.sender, (long)e.time, e.character, SWTKeyEventAdapter.adaptSWTKeyCodeToAWTKeyCode(e.keyCode), SWTKeyEventAdapter.adaptSWTModifierToAWTModifier(e.stateMask)));
    }

    public void keyReleased(KeyEvent e) {
        this.handleEvent((Event)new KeyEvent.KeyReleasedEvent(this.sender, (long)e.time, e.character, SWTKeyEventAdapter.adaptSWTKeyCodeToAWTKeyCode(e.keyCode), SWTKeyEventAdapter.adaptSWTModifierToAWTModifier(e.stateMask)));
    }

    public static int adaptSWTKeyCodeToAWTKeyCode(int swtKeyCode) {
        int c = swtKeyCode;
        if (swtKeyCode >= 97 && swtKeyCode <= 122) {
            return swtKeyCode - 32;
        }
        switch (swtKeyCode) {
            case 0x1000001: {
                return 38;
            }
            case 0x1000002: {
                return 40;
            }
            case 0x1000003: {
                return 37;
            }
            case 0x1000004: {
                return 39;
            }
            case 0x1000005: {
                return 33;
            }
            case 0x1000006: {
                return 34;
            }
            case 0x1000007: {
                return 36;
            }
            case 0x1000008: {
                return 35;
            }
            case 0x1000009: {
                return 155;
            }
            case 0x100000A: {
                return 112;
            }
            case 0x100000B: {
                return 113;
            }
            case 0x100000C: {
                return 114;
            }
            case 0x100000D: {
                return 115;
            }
            case 0x100000E: {
                return 116;
            }
            case 0x100000F: {
                return 117;
            }
            case 0x1000010: {
                return 118;
            }
            case 0x1000011: {
                return 119;
            }
            case 0x1000012: {
                return 120;
            }
            case 0x1000013: {
                return 121;
            }
            case 0x1000014: {
                return 122;
            }
            case 0x1000015: {
                return 123;
            }
            case 0x1000016: {
                return 61440;
            }
            case 0x1000017: {
                return 61441;
            }
            case 0x1000018: {
                return 61442;
            }
            case 16777258: {
                return 106;
            }
            case 16777259: {
                return 107;
            }
            case 16777261: {
                return 109;
            }
            case 16777262: {
                return 110;
            }
            case 16777263: {
                return 111;
            }
            case 0x1000030: {
                return 96;
            }
            case 0x1000031: {
                return 97;
            }
            case 16777266: {
                return 98;
            }
            case 0x1000033: {
                return 99;
            }
            case 16777268: {
                return 100;
            }
            case 16777269: {
                return 101;
            }
            case 16777270: {
                return 102;
            }
            case 16777271: {
                return 103;
            }
            case 16777272: {
                return 104;
            }
            case 16777273: {
                return 105;
            }
            case 16777277: {
                return 61;
            }
            case 0x1000050: {
                return 10;
            }
            case 0x1000051: {
                return 156;
            }
            case 16777298: {
                return 20;
            }
            case 16777299: {
                return 144;
            }
            case 16777300: {
                return 144;
            }
            case 0x1000055: {
                return 19;
            }
            case 16777303: {
                return 154;
            }
            case 39: {
                return 222;
            }
            case 127: {
                return 127;
            }
            case 13: {
                return 10;
            }
            case 27: {
                return 27;
            }
            case 9: {
                return 9;
            }
            case 65536: {
                return 18;
            }
            case 131072: {
                return 16;
            }
            case 262144: {
                return 17;
            }
            case 0x400000: {
                return 157;
            }
            case 8: {
                return 8;
            }
        }
        if (c >= 0 && c < 255) {
            return c;
        }
        return c;
    }

    public static int adaptSWTModifierToAWTModifier(int swtModifier) {
        boolean command;
        int c = swtModifier;
        int result = 0;
        boolean alt = (c & 0x10000) != 0;
        boolean ctrl = (c & 0x40000) != 0;
        boolean shift = (c & 0x20000) != 0;
        boolean bl = command = (c & 0x400000) != 0;
        if (alt) {
            result |= 0x208;
        }
        if (ctrl) {
            result |= 0x82;
        }
        if (alt && ctrl) {
            result |= 0x2020;
        }
        if (shift) {
            result |= 0x41;
        }
        if (command) {
            result |= 0x104;
        }
        return result;
    }
}

