/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.g2d.elementclass.slider;

import java.awt.Graphics2D;
import java.awt.geom.Line2D;
import java.awt.geom.Path2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import org.simantics.g2d.canvas.ICanvasContext;
import org.simantics.g2d.diagram.participant.DiagramParticipant;
import org.simantics.g2d.element.ElementHints;
import org.simantics.g2d.element.ElementUtils;
import org.simantics.g2d.element.IElement;
import org.simantics.g2d.element.SceneGraphNodeKey;
import org.simantics.g2d.element.handler.SceneGraph;
import org.simantics.g2d.element.handler.Stateful;
import org.simantics.g2d.element.handler.impl.AbstractGrabbable;
import org.simantics.g2d.elementclass.slider.SliderColorProfile;
import org.simantics.scenegraph.Node;
import org.simantics.scenegraph.g2d.G2DNode;
import org.simantics.scenegraph.g2d.G2DParentNode;
import org.simantics.scenegraph.g2d.events.MouseEvent;
import org.simantics.utils.datastructures.hints.IHintContext;

public class SliderHandle
extends AbstractGrabbable
implements SceneGraph {
    private static final long serialVersionUID = 3632511991491704966L;
    public static final IHintContext.Key KEY_SLIDER_COLOR_PROFILE = new IHintContext.KeyOf(SliderColorProfile.class);
    public static final IHintContext.Key KEY_SLIDER_POSITION = ElementHints.KEY_VALUE;
    public static final IHintContext.Key KEY_SLIDER_MIN_VALUE = ElementHints.KEY_MIN_VALUE;
    public static final IHintContext.Key KEY_SLIDER_MAX_VALUE = ElementHints.KEY_MAX_VALUE;
    public static final SliderHandle INSTANCE = new SliderHandle();
    public IHintContext.Key positionKey = KEY_SLIDER_POSITION;
    public static final IHintContext.Key SG_NODE = new SceneGraphNodeKey(Node.class, "SUB_SG_NODE");
    private static final IHintContext.Key KEY_HANDLE_GRAB_POS = new IHintContext.KeyOf(Double.class);

    public SliderHandle() {
        super(1000.0);
    }

    @Override
    public void cleanup(IElement e) {
        Node node = (Node)e.removeHint(SG_NODE);
        if (node != null) {
            node.remove();
        }
    }

    @Override
    public void init(IElement e, G2DParentNode parent) {
        CustomSliderNode node = (CustomSliderNode)((Object)e.getHint(SG_NODE));
        if (node == null) {
            node = (CustomSliderNode)((Object)parent.addNode(CustomSliderNode.class));
            e.setHint(SG_NODE, (Object)node);
        }
        SliderColorProfile colors = (SliderColorProfile)e.getHint(KEY_SLIDER_COLOR_PROFILE);
        Rectangle2D rect = this.getBounds(e);
        boolean enabled = this.isEnabled(e);
        double handleWidth = this.getHandleWidth(e);
        double handleOffset = this.getHandleOffset(e);
        node.init(rect, enabled, colors, handleWidth, handleOffset);
    }

    @Override
    protected boolean onGrabCheck(IElement e, ICanvasContext ctx, int pointerId, Point2D pickPos) {
        boolean pointerOnHandle;
        if (!this.isEnabled(e)) {
            return false;
        }
        Point2D mouseElementPos = ElementUtils.controlToElementCoordinate(e, ctx, pickPos, null);
        Rectangle2D bounds = this.getBounds(e);
        if (!bounds.contains(mouseElementPos)) {
            return false;
        }
        double x = mouseElementPos.getX() - bounds.getMinX();
        mouseElementPos.getY();
        bounds.getMinY();
        double handleOffset = this.getHandleOffset(e);
        double handleWidth = this.getHandleWidth(e);
        boolean bl = pointerOnHandle = x >= handleOffset && x <= handleOffset + handleWidth;
        if (!pointerOnHandle) {
            return false;
        }
        return this.getGrabCount(e, ctx) <= 1;
    }

    @Override
    protected void onDrag(AbstractGrabbable.GrabInfo gi, ICanvasContext ctx) {
        IElement e = gi.e;
        DiagramParticipant dp = (DiagramParticipant)ctx.getSingleItem(DiagramParticipant.class);
        this.getBounds(e);
        double grabPosOnHandle = (Double)dp.getElementHint(gi.e, KEY_HANDLE_GRAB_POS);
        double trackWidth = this.getTrackWidth(e);
        double handleWidth = this.getHandleWidth(e);
        double varaa = trackWidth - handleWidth + 1.0;
        double suggestedHandlePos = gi.dragPosElement.getX() - grabPosOnHandle;
        double suggestedOffset = suggestedHandlePos / varaa;
        double min = (Double)e.getHint(KEY_SLIDER_MIN_VALUE);
        double max = (Double)e.getHint(KEY_SLIDER_MAX_VALUE);
        double suggestedPosition = suggestedOffset * (max - min) + min;
        this.setPosition(e, suggestedPosition);
    }

    @Override
    public boolean handleMouseEvent(IElement e, ICanvasContext ctx, MouseEvent me) {
        boolean pointerInBeginning;
        double my;
        double mx;
        boolean superResult = super.handleMouseEvent(e, ctx, me);
        if (superResult) {
            return superResult;
        }
        if (!(me instanceof MouseEvent.MouseClickEvent)) {
            return false;
        }
        MouseEvent.MouseClickEvent mpe = (MouseEvent.MouseClickEvent)me;
        if (mpe.button != 1) {
            return false;
        }
        Point2D mouseElementPos = ElementUtils.controlToElementCoordinate(e, ctx, me.controlPosition, null);
        Rectangle2D rect = this.getBounds(e);
        boolean onTrackRect = rect.contains(mx = mouseElementPos.getX(), my = mouseElementPos.getY());
        if (!onTrackRect) {
            return false;
        }
        my -= rect.getMinY();
        double trackWidth = this.getTrackWidth(e);
        double handleOffset = this.getHandleOffset(e);
        double handleWidth = this.getHandleWidth(e);
        boolean pointerOnHandle = (mx -= rect.getMinX()) >= handleOffset && mx <= handleOffset + handleWidth;
        boolean bl = pointerInBeginning = mx < handleOffset;
        if (pointerOnHandle) {
            return false;
        }
        double min = (Double)e.getHint(KEY_SLIDER_MIN_VALUE);
        double max = (Double)e.getHint(KEY_SLIDER_MAX_VALUE);
        double pageIncrement = (max - min) / (trackWidth / handleWidth);
        if (!pointerInBeginning) {
            pageIncrement *= -1.0;
        }
        this.modifyPosition(e, -pageIncrement);
        return true;
    }

    @Override
    protected void onGrab(AbstractGrabbable.GrabInfo gi, ICanvasContext ctx) {
        double handlePos = this.getHandleOffset(gi.e);
        double grabPosOnHandle = gi.grabPosElement.getX() - handlePos;
        DiagramParticipant dp = (DiagramParticipant)ctx.getSingleItem(DiagramParticipant.class);
        dp.setElementHint(gi.e, KEY_HANDLE_GRAB_POS, grabPosOnHandle);
    }

    @Override
    protected void onGrabCancel(AbstractGrabbable.GrabInfo gi, ICanvasContext ctx) {
        DiagramParticipant dp = (DiagramParticipant)ctx.getSingleItem(DiagramParticipant.class);
        dp.removeElementHint(gi.e, KEY_HANDLE_GRAB_POS);
    }

    @Override
    protected void onRelease(AbstractGrabbable.GrabInfo gi, ICanvasContext ctx) {
        DiagramParticipant dp = (DiagramParticipant)ctx.getSingleItem(DiagramParticipant.class);
        dp.removeElementHint(gi.e, KEY_HANDLE_GRAB_POS);
    }

    public synchronized void modifyPosition(IElement e, double modification) {
        Double position = (Double)e.getHint(this.positionKey);
        if (position == null) {
            position = 0.0;
        }
        double newPosition = position + modification;
        this.setPosition(e, newPosition);
    }

    public synchronized void setPosition(IElement e, double position) {
        double min = (Double)e.getHint(KEY_SLIDER_MIN_VALUE);
        double max = (Double)e.getHint(KEY_SLIDER_MAX_VALUE);
        if (position < min) {
            position = min;
        }
        if (position > max) {
            position = max;
        }
        e.setHint(this.positionKey, position);
    }

    public double getPosition(IElement e) {
        Double d = (Double)e.getHint(this.positionKey);
        if (d == null) {
            return 0.0;
        }
        return d;
    }

    private double getHandleOffset(IElement e) {
        double position = this.getPosition(e);
        double min = (Double)e.getHint(KEY_SLIDER_MIN_VALUE);
        double max = (Double)e.getHint(KEY_SLIDER_MAX_VALUE);
        double width = this.getTrackWidth(e);
        double handleWidth = SliderHandle._calcHandleLength(width, min, max);
        return SliderHandle._calcHandleOffset(width, handleWidth, position, min, max);
    }

    protected double getHandleWidth(IElement e) {
        double min = (Double)e.getHint(KEY_SLIDER_MIN_VALUE);
        double max = (Double)e.getHint(KEY_SLIDER_MAX_VALUE);
        double width = this.getTrackWidth(e);
        return SliderHandle._calcHandleLength(width, min, max);
    }

    private double getTrackWidth(IElement e) {
        return this.getBounds(e).getWidth();
    }

    private static double _calcHandleOffset(double trackLength, double handleLength, double position, double min, double max) {
        double varaa = trackLength - handleLength + 1.0;
        double relativePos = (position - min) / (max - min);
        return varaa * relativePos;
    }

    private static double _calcHandleLength(double width, double min, double max) {
        double len = width / (max - min + 1.0);
        if (len < 28.0) {
            len = 28.0;
        }
        return len;
    }

    public boolean isEnabled(IElement e) {
        Stateful enabled = e.getElementClass().getAtMostOneItemOfClass(Stateful.class);
        if (enabled == null) {
            return true;
        }
        return enabled.isEnabled(e);
    }

    protected Rectangle2D getBounds(IElement e) {
        return ElementUtils.getElementBounds(e);
    }

    public static class CustomSliderNode
    extends G2DNode {
        private static final long serialVersionUID = 1423400213815428725L;
        Rectangle2D rect = null;
        boolean enabled = false;
        SliderColorProfile colors = null;
        double handleWidth = 0.0;
        double handleOffset = 0.0;

        public Rectangle2D getBoundsInLocal() {
            return this.rect;
        }

        public void init(Rectangle2D rect, boolean enabled, SliderColorProfile colors, double handleWidth, double handleOffset) {
            this.rect = rect;
            this.enabled = enabled;
            this.colors = colors;
            this.handleWidth = handleWidth;
            this.handleOffset = handleOffset;
        }

        public void render(Graphics2D g) {
            double height = this.rect.getHeight();
            Rectangle2D.Double r = new Rectangle2D.Double();
            Line2D.Double l = new Line2D.Double();
            g.translate(this.rect.getMinX(), this.rect.getMinY());
            g.translate(this.handleOffset, 0.0);
            g.setColor(this.enabled ? this.colors.HANDLE4 : this.colors.DISABLED_HANDLE4);
            r.setFrame(1.0, 1.0, this.handleWidth - 3.0, (height += 1.0) - 3.0);
            g.fill(r);
            g.setColor(this.enabled ? this.colors.HANDLE3 : this.colors.DISABLED_HANDLE3);
            ((Line2D)l).setLine(2.0, 1.0, this.handleWidth - 3.0, 1.0);
            g.draw(l);
            ((Line2D)l).setLine(1.0, 2.0, 1.0, height - 3.0);
            g.draw(l);
            g.setColor(this.enabled ? this.colors.HANDLE5 : this.colors.DISABLED_HANDLE5);
            ((Line2D)l).setLine(2.0, height - 2.0, this.handleWidth - 3.0, height - 2.0);
            g.draw(l);
            ((Line2D)l).setLine(this.handleWidth - 2.0, 2.0, this.handleWidth - 2.0, height - 3.0);
            g.draw(l);
            g.setColor(this.enabled ? this.colors.HANDLE2 : this.colors.DISABLED_HANDLE2);
            Path2D.Double p = new Path2D.Double();
            ((Path2D)p).moveTo(0.0, 2.0);
            ((Path2D)p).lineTo(2.0, 0.0);
            ((Path2D)p).lineTo(this.handleWidth - 3.0, 0.0);
            ((Path2D)p).lineTo(this.handleWidth - 1.0, 2.0);
            ((Path2D)p).lineTo(this.handleWidth - 1.0, height - 3.0);
            ((Path2D)p).lineTo(this.handleWidth - 3.0, height - 1.0);
            ((Path2D)p).lineTo(2.0, height - 1.0);
            ((Path2D)p).lineTo(0.0, height - 3.0);
            ((Path2D)p).lineTo(0.0, 2.0);
            p.closePath();
            g.draw(p);
            if (this.handleWidth > height) {
                g.translate((this.handleWidth - height) / 2.0, 0.0);
                g.setColor(this.enabled ? this.colors.HANDLE8 : this.colors.DISABLED_HANDLE8);
                g.drawLine((int)(height * 0.2), (int)(height * 0.55) + 1, (int)(height * 0.4), (int)(height * 0.35) + 1);
                g.setColor(this.enabled ? this.colors.HANDLE7 : this.colors.DISABLED_HANDLE7);
                g.drawLine((int)(height * 0.2), (int)(height * 0.55), (int)(height * 0.4), (int)(height * 0.35));
                g.setColor(this.enabled ? this.colors.HANDLE8 : this.colors.DISABLED_HANDLE8);
                g.drawLine((int)(height * 0.4), (int)(height * 0.6) + 1, (int)(height * 0.65), (int)(height * 0.3) + 1);
                g.setColor(this.enabled ? this.colors.HANDLE7 : this.colors.DISABLED_HANDLE7);
                g.drawLine((int)(height * 0.4), (int)(height * 0.6), (int)(height * 0.65), (int)(height * 0.3));
                g.setColor(this.enabled ? this.colors.HANDLE8 : this.colors.DISABLED_HANDLE8);
                g.drawLine((int)(height * 0.62), (int)(height * 0.6) + 1, (int)(height * 0.8), (int)(height * 0.4) + 1);
                g.setColor(this.enabled ? this.colors.HANDLE7 : this.colors.DISABLED_HANDLE7);
                g.drawLine((int)(height * 0.62), (int)(height * 0.6), (int)(height * 0.8), (int)(height * 0.4));
            }
        }
    }
}

