/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.g2d.elementclass;

import org.simantics.g2d.element.ElementHints;
import org.simantics.g2d.element.IElement;
import org.simantics.g2d.element.handler.PropertySetter;
import org.simantics.g2d.elementclass.AnimatedNode;
import org.simantics.scenegraph.INode;
import org.simantics.scenegraph.Node;
import org.simantics.scenegraph.ParentNode;
import org.simantics.scenegraph.g2d.G2DParentNode;
import org.simantics.scenegraph.g2d.IG2DNode;
import org.simantics.scenegraph.utils.NodeUtil;
import org.simantics.utils.datastructures.hints.IHintContext;

public class PlainElementPropertySetter
implements PropertySetter {
    private static final long serialVersionUID = -3165827599737160621L;
    public static final PlainElementPropertySetter INSTANCE = new PlainElementPropertySetter(ElementHints.KEY_SG_NODE);
    public static final IHintContext.Key KEY_PROFILE_PROPERTIES = new IHintContext.KeyOf(ElementHints.Properties.class, "ELEMENT_PROFILE_PROPERTIES");
    private final IHintContext.Key key;

    public PlainElementPropertySetter(IHintContext.Key key) {
        this.key = key;
    }

    @Override
    public void overrideProperties(IElement e, ElementHints.Properties properties) {
        ElementHints.Properties profile = (ElementHints.Properties)e.getHint(KEY_PROFILE_PROPERTIES);
        if (profile == null) {
            profile = new ElementHints.Properties();
            e.setHint(KEY_PROFILE_PROPERTIES, profile);
        }
        profile.clear();
        profile.putAll(properties);
    }

    @Override
    public void overrideProperty(IElement e, String name, Object value) {
        ElementHints.Properties profile = (ElementHints.Properties)e.getHint(KEY_PROFILE_PROPERTIES);
        if (profile == null) {
            profile = new ElementHints.Properties();
            e.setHint(KEY_PROFILE_PROPERTIES, profile);
        }
        profile.put(name, value);
    }

    private Node findSingle(Node node, Class<?> clazz) {
        if (clazz.isInstance(node)) {
            return node;
        }
        if (node instanceof G2DParentNode) {
            G2DParentNode parent = (G2DParentNode)node;
            Node found = null;
            for (IG2DNode child : parent.getNodes()) {
                Node test;
                if (!(child instanceof Node) || (test = this.findSingle((Node)child, clazz)) == null) continue;
                if (found == null) {
                    found = test;
                    continue;
                }
                return null;
            }
            return found;
        }
        return null;
    }

    private Node findAnimatedNode(Node node) {
        Node animated = this.findSingle(node, AnimatedNode.class);
        if (animated != null) {
            return animated;
        }
        return node;
    }

    @Override
    public void syncPropertiesToNode(IElement e) {
        ElementHints.Properties profile = (ElementHints.Properties)e.getHint(KEY_PROFILE_PROPERTIES);
        ElementHints.Properties element = (ElementHints.Properties)e.getHint(ElementHints.KEY_ELEMENT_PROPERTIES);
        Node node = (Node)e.getHint(this.key);
        if (node == null) {
            return;
        }
        node = this.findAnimatedNode(node);
        ElementHints.Properties concat = new ElementHints.Properties();
        if (element != null) {
            for (String key : element.keySet()) {
                concat.put(key, element.get(key));
            }
        }
        if (profile != null) {
            for (String key : profile.keySet()) {
                concat.put(key, profile.get(key));
            }
        }
        for (String property : concat.keySet()) {
            if (property.contains(".")) {
                INode child;
                String[] t = property.split("\\.");
                if (t.length != 2) continue;
                String child_name = t[0];
                String property_name = t[1];
                if (!(node instanceof G2DParentNode) || (child = NodeUtil.findChildById((ParentNode)((G2DParentNode)node), (String)child_name)) == null) continue;
                NodeUtil.setPropertyIfSupported((String)property_name, concat.get(property), (INode)child);
                continue;
            }
            NodeUtil.setPropertyIfSupported((String)property, concat.get(property), (INode)node);
        }
    }
}

