/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.g2d.elementclass;

import java.awt.Color;
import java.awt.Paint;
import java.awt.Shape;
import java.awt.geom.Rectangle2D;
import org.simantics.g2d.element.ElementClass;
import org.simantics.g2d.element.ElementUtils;
import org.simantics.g2d.element.IElement;
import org.simantics.g2d.element.handler.SceneGraph;
import org.simantics.g2d.element.handler.impl.DefaultTransform;
import org.simantics.g2d.element.handler.impl.FillColorImpl;
import org.simantics.g2d.element.handler.impl.Resizeable;
import org.simantics.scenegraph.g2d.G2DParentNode;
import org.simantics.scenegraph.g2d.nodes.ShapeNode;

public class FilmClass {
    public static final Color FILM_COLOR = new Color(0.0f, 0.0f, 0.0f, 0.5f);
    public static final ElementClass FILM_CLASS = ElementClass.compile(DefaultTransform.INSTANCE, Resizeable.UNCONSTRICTED, FillColorImpl.handlerOf(FILM_COLOR), new FilmSGNode());

    static class FilmSGNode
    implements SceneGraph {
        private static final long serialVersionUID = -7763377402727204557L;
        private ShapeNode node = null;

        FilmSGNode() {
        }

        @Override
        public void cleanup(IElement e) {
            if (this.node != null) {
                this.node.remove();
            }
            this.node = null;
        }

        @Override
        public void init(IElement e, G2DParentNode parent) {
            if (this.node == null) {
                this.node = (ShapeNode)parent.addNode(ShapeNode.class);
            }
            Color fillColor = ElementUtils.getFillColor(e);
            Rectangle2D rect = ElementUtils.getElementBounds(e);
            this.node.setColor((Paint)fillColor);
            this.node.setFill(true);
            this.node.setShape((Shape)rect);
        }
    }
}

