/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.g2d.elementclass;

import java.awt.Color;
import java.awt.Paint;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import org.simantics.g2d.diagram.IDiagram;
import org.simantics.g2d.diagram.handler.Topology;
import org.simantics.g2d.element.ElementClass;
import org.simantics.g2d.element.ElementUtils;
import org.simantics.g2d.element.IElement;
import org.simantics.g2d.element.handler.Transform;
import org.simantics.g2d.element.handler.impl.BranchPointTerminal;
import org.simantics.g2d.element.handler.impl.DefaultTransform;
import org.simantics.g2d.element.handler.impl.ObjectTerminal;
import org.simantics.g2d.element.handler.impl.OutlinePick;
import org.simantics.g2d.element.handler.impl.ParentImpl;
import org.simantics.g2d.element.handler.impl.SimpleElementLayers;
import org.simantics.g2d.element.handler.impl.StaticSymbolImageInitializer;
import org.simantics.g2d.element.handler.impl.StaticSymbolImpl;
import org.simantics.g2d.element.handler.impl.Terminals;
import org.simantics.g2d.element.handler.impl.TextImpl;
import org.simantics.g2d.elementclass.BranchPoint;
import org.simantics.g2d.elementclass.ImageClass;
import org.simantics.g2d.image.Image;
import org.simantics.g2d.image.impl.ShapeImage;
import org.simantics.g2d.utils.geom.DirectionSet;
import org.simantics.scenegraph.g2d.G2DParentNode;
import org.simantics.scenegraph.g2d.nodes.BranchPointNode;
import org.simantics.utils.datastructures.hints.IHintContext;

public class BranchPointClass {
    private static final IHintContext.Key KEY_DIRECTION = new IHintContext.KeyOf(BranchPoint.Direction.class, "BRANCH_POINT_DIRECTION");
    private static final BranchPoint BRANCH_POINT = new BranchPoint(){
        private static final long serialVersionUID = 8529882246314074853L;

        @Override
        public BranchPoint.Direction getDirectionPreference(IElement e, BranchPoint.Direction defaultValue) {
            BranchPoint.Direction d = (BranchPoint.Direction)((Object)e.getHint(KEY_DIRECTION));
            return d != null ? d : defaultValue;
        }

        @Override
        public void setDirectionPreference(IElement e, BranchPoint.Direction value) {
            if (value == null) {
                e.removeHint(KEY_DIRECTION);
            } else {
                e.setHint(KEY_DIRECTION, (Object)value);
            }
        }
    };
    public static final Image DEFAULT_IMAGE = new ShapeImage(BranchPointNode.SHAPE, (Paint)Color.BLACK, null, Image.VOLATILE_VECTOR);
    public static final Image DEFAULT_IMAGE2 = new ShapeImage(BranchPointNode.SHAPE2, (Paint)Color.LIGHT_GRAY, null, Image.VOLATILE_VECTOR);
    private static final ObjectTerminal TERMINAL = BranchPointTerminal.existingTerminal(new AffineTransform(), DirectionSet.ANY, DEFAULT_IMAGE.getOutline());
    private static final Terminals TERMINALS = new Terminals(Collections.singletonList(TERMINAL)){
        private static final long serialVersionUID = -6094665667025529239L;
        private final Collection<Topology.Connection> connections = new ArrayList<Topology.Connection>();

        @Override
        public Shape getTerminalShape(IElement e, Topology.Terminal t) {
            IDiagram d = ElementUtils.peekDiagram(e);
            if (d == null) {
                return null;
            }
            Topology topology = d.getDiagramClass().getAtMostOneItemOfClass(Topology.class);
            this.connections.clear();
            topology.getConnections(e, TERMINAL, this.connections);
            int degree = this.connections.size();
            this.connections.clear();
            if (degree > 2) {
                return BranchPointNode.SHAPE;
            }
            return BranchPointNode.SHAPE2;
        }
    };
    private static final ImageClass.ImageElementHandler DEFAULT_IMAGE_ELEMENT_HANDLER = new ImageClass.ImageElementHandler(){
        private static final long serialVersionUID = 68445770951872084L;
        private final Collection<Topology.Connection> connections = new ArrayList<Topology.Connection>();

        @Override
        public void init(IElement e, G2DParentNode parent) {
            Transform transform;
            AffineTransform at;
            BranchPointNode node = (BranchPointNode)e.getHint(KEY_SG_NODE);
            if (node == null) {
                node = (BranchPointNode)parent.addNode("bp_" + e.hashCode(), BranchPointNode.class);
                e.setHint(KEY_SG_NODE, node);
            }
            if ((at = (transform = e.getElementClass().getSingleItem(Transform.class)).getTransform(e)) != null) {
                node.setTransform((AffineTransform)at.clone());
            }
            node.setDegree(this.getDegree(e));
            node.setDirection(this.getDirection(e));
        }

        private byte getDirection(IElement e) {
            return (byte)ElementUtils.getHintOrDefault(e, KEY_DIRECTION, BranchPoint.Direction.Any).ordinal();
        }

        private int getDegree(IElement e) {
            IDiagram d = ElementUtils.peekDiagram(e);
            if (d == null) {
                return 0;
            }
            Topology t = d.getDiagramClass().getAtMostOneItemOfClass(Topology.class);
            this.connections.clear();
            t.getConnections(e, TERMINAL, this.connections);
            int degree = this.connections.size();
            this.connections.clear();
            return degree;
        }

        @Override
        public void cleanup(IElement e) {
            e.removeHint(KEY_SG_NODE);
        }
    };
    public static final ElementClass CLASS = ElementClass.compile(TextImpl.INSTANCE, ParentImpl.INSTANCE, DefaultTransform.INSTANCE, DEFAULT_IMAGE_ELEMENT_HANDLER, OutlinePick.INSTANCE, StaticSymbolImageInitializer.INSTANCE, new StaticSymbolImpl(DEFAULT_IMAGE), TERMINALS, SimpleElementLayers.INSTANCE, BRANCH_POINT).setId(BranchPointClass.class.getSimpleName());
}

