/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.g2d.element.handler.impl;

import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import org.simantics.g2d.element.ElementHints;
import org.simantics.g2d.element.IElement;
import org.simantics.g2d.element.handler.Rotate;

public class Rotateable
implements Rotate {
    private static final long serialVersionUID = -1218542543108449939L;
    public static final Rotateable HANDLER = new Rotateable();

    @Override
    public void rotate(IElement e, double theta, Point2D origo) {
        if (Double.isNaN(theta)) {
            return;
        }
        AffineTransform at = (AffineTransform)e.getHint(ElementHints.KEY_TRANSFORM);
        at = (AffineTransform)at.clone();
        at.rotate(theta, origo.getX(), origo.getY());
        e.setHint(ElementHints.KEY_TRANSFORM, at);
    }

    @Override
    public double getAngle(IElement e) {
        AffineTransform at = (AffineTransform)e.getHint(ElementHints.KEY_TRANSFORM);
        double m01 = at.getShearX();
        double m11 = at.getScaleY();
        return -Math.atan2(m01, m11);
    }
}

