/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.g2d.element.handler.impl;

import java.awt.geom.Rectangle2D;
import java.util.Collection;
import org.simantics.g2d.canvas.ICanvasContext;
import org.simantics.g2d.diagram.IDiagram;
import org.simantics.g2d.element.ElementHints;
import org.simantics.g2d.element.IElement;
import org.simantics.g2d.element.handler.LifeCycle;
import org.simantics.g2d.element.handler.Resize;
import org.simantics.g2d.element.handler.Validator;

public class Resizeable
implements Resize,
LifeCycle,
Validator {
    private static final long serialVersionUID = -2892730866940581731L;
    public static final Resizeable UNCONSTRICTED = new Resizeable(new Rectangle2D.Double(0.0, 0.0, 100.0, 100.0), null, null, null);
    Rectangle2D minSize;
    Rectangle2D maxSize;
    Rectangle2D initialSize;
    Double aspectRatio;

    public static Resizeable initialSize(double width, double height) {
        return new Resizeable(new Rectangle2D.Double(0.0, 0.0, width, height), null, null, null);
    }

    public Resizeable() {
        this(null, null, null, null);
    }

    public Resizeable(Rectangle2D initialSize, Rectangle2D minSize, Rectangle2D maxSize, Double fixedAspectRatio) {
        this.minSize = minSize;
        this.maxSize = maxSize;
        this.initialSize = initialSize;
        this.aspectRatio = fixedAspectRatio;
        if (this.aspectRatio != null) {
            double msar;
            if (minSize != null && Math.abs((msar = minSize.getWidth() / minSize.getHeight()) - this.aspectRatio) > 1.0E-6) {
                throw new RuntimeException("The aspect ratio of MinSize does not match the given fixed aspect ratio");
            }
            if (maxSize != null && Math.abs((msar = maxSize.getWidth() / maxSize.getHeight()) - this.aspectRatio) > 1.0E-6) {
                throw new RuntimeException("The aspect ratio of MinSize does not match the given fixed aspect ratio");
            }
        }
    }

    @Override
    public Double getFixedAspectRatio(IElement e) {
        return this.aspectRatio;
    }

    @Override
    public Rectangle2D getMaximumSize(IElement e) {
        return this.maxSize;
    }

    @Override
    public Rectangle2D getMinimumSize(IElement e) {
        return this.minSize;
    }

    @Override
    public Rectangle2D getBounds(IElement e, Rectangle2D s) {
        if (s == null) {
            s = new Rectangle2D.Double();
        }
        s.setFrame((Rectangle2D)e.getHint(ElementHints.KEY_BOUNDS));
        return s;
    }

    @Override
    public void resize(IElement e, Rectangle2D newSize) {
        e.setHint(ElementHints.KEY_BOUNDS, newSize);
    }

    @Override
    public void validate(IElement e, ICanvasContext ctx, Collection<Validator.Issue> lst) {
    }

    @Override
    public void onElementActivated(IDiagram d, IElement e) {
    }

    @Override
    public void onElementCreated(IElement e) {
        if (this.initialSize != null) {
            e.setHint(ElementHints.KEY_BOUNDS, this.initialSize);
        } else {
            e.setHint(ElementHints.KEY_BOUNDS, new Rectangle2D.Double(0.0, 0.0, 1.0, 1.0));
        }
    }

    @Override
    public void onElementDestroyed(IElement e) {
    }

    @Override
    public void onElementDeactivated(IDiagram d, IElement e) {
    }
}

