/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.g2d.element.handler.impl;

import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import org.simantics.g2d.element.ElementHints;
import org.simantics.g2d.element.IElement;
import org.simantics.g2d.element.handler.Move;

public class MoveImpl
implements Move {
    private static final long serialVersionUID = 1395438821342445141L;
    public static final MoveImpl HANDLER = new MoveImpl();

    @Override
    public Point2D getPosition(IElement e) {
        AffineTransform at = (AffineTransform)e.getHint(ElementHints.KEY_TRANSFORM);
        Point2D.Double p = new Point2D.Double(at.getTranslateX(), at.getTranslateY());
        return p;
    }

    @Override
    public void moveTo(IElement e, double x, double y) {
        AffineTransform origAt = (AffineTransform)e.getHint(ElementHints.KEY_TRANSFORM);
        double oldX = origAt.getTranslateX();
        double oldY = origAt.getTranslateY();
        AffineTransform move = new AffineTransform();
        move.setToTranslation(x - oldX, y - oldY);
        AffineTransform at2 = new AffineTransform(origAt);
        at2.preConcatenate(move);
        e.setHint(ElementHints.KEY_TRANSFORM, at2);
    }
}

