/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.g2d.element;

import java.util.HashMap;
import java.util.Map;
import org.simantics.g2d.element.ElementClass;
import org.simantics.g2d.element.IElementClassProvider;

public class ElementClassProviders {
    public static IElementClassProvider staticProvider(final ElementClass clazz) {
        return new IElementClassProvider(){

            @Override
            public ElementClass get(Object key) {
                return clazz;
            }
        };
    }

    public static IElementClassProvider mappedProvider(Map<Object, ElementClass> map) {
        final HashMap<Object, ElementClass> copy = new HashMap<Object, ElementClass>(map);
        return new IElementClassProvider(){

            @Override
            public ElementClass get(Object key) {
                return (ElementClass)copy.get(key);
            }
        };
    }

    public static IElementClassProvider mappedProvider(Object ... keyClassPairs) {
        if (keyClassPairs.length % 2 != 0) {
            throw new IllegalArgumentException();
        }
        HashMap<Object, ElementClass> map = new HashMap<Object, ElementClass>();
        int n = keyClassPairs.length / 2;
        int i = 0;
        while (i < n) {
            Object key = keyClassPairs[i * 2];
            Object elementClass = keyClassPairs[i * 2 + 1];
            if (!(elementClass instanceof ElementClass)) {
                throw new IllegalArgumentException("not an ElementClass instance: " + String.valueOf(elementClass));
            }
            map.put(key, (ElementClass)elementClass);
            ++i;
        }
        return ElementClassProviders.mappedProvider(map);
    }
}

