/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.g2d.diagram.participant;

import java.awt.geom.Point2D;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.simantics.g2d.canvas.IMouseCaptureContext;
import org.simantics.g2d.canvas.IMouseCaptureHandle;
import org.simantics.g2d.canvas.IMouseCaptureHandleListener;
import org.simantics.g2d.canvas.impl.DependencyReflection;
import org.simantics.g2d.diagram.handler.PickContext;
import org.simantics.g2d.diagram.handler.PickRequest;
import org.simantics.g2d.diagram.participant.AbstractDiagramParticipant;
import org.simantics.g2d.element.IElement;
import org.simantics.g2d.element.handler.HandleMouseEvent;
import org.simantics.g2d.participant.TransformUtil;
import org.simantics.scenegraph.g2d.events.EventHandlerReflection;
import org.simantics.scenegraph.g2d.events.MouseEvent;

public class ElementInteractor
extends AbstractDiagramParticipant {
    @DependencyReflection.Dependency
    PickContext pick;
    @DependencyReflection.Dependency
    TransformUtil util;
    private PickRequest.PickSorter pickSorter;
    public static final int INTERACTOR_PRIORITY = 0x7FFFFFFD;
    Map<Integer, ElementMouseCaptureHandle> mouseCaptureMap = new HashMap<Integer, ElementMouseCaptureHandle>();
    Map<Integer, IElement> mouseFocus = new HashMap<Integer, IElement>();
    private IElement previousTarget = null;

    public ElementInteractor() {
    }

    public ElementInteractor(PickRequest.PickSorter pickSorter) {
        this.pickSorter = pickSorter;
    }

    public IMouseCaptureHandle captureMouse(IElement element, int mouseId) {
        IMouseCaptureContext mcc;
        ElementMouseCaptureHandle prevHnd = this.mouseCaptureMap.get(mouseId);
        if (prevHnd != null) {
            prevHnd.release();
            this.mouseCaptureMap.remove(mouseId);
        }
        if ((mcc = this.getContext().getMouseCaptureContext()) == null) {
            return null;
        }
        ElementMouseCaptureHandle hnd = new ElementMouseCaptureHandle();
        hnd.origHandle = mcc.captureMouse(mouseId);
        hnd.element = element;
        this.mouseCaptureMap.put(mouseId, hnd);
        return hnd;
    }

    public Collection<IMouseCaptureHandle> getGrabsOfElement(IElement e) {
        ArrayList<IMouseCaptureHandle> result = new ArrayList<IMouseCaptureHandle>();
        for (ElementMouseCaptureHandle eh : this.mouseCaptureMap.values()) {
            if (eh.element != e) continue;
            result.add(eh);
        }
        return result;
    }

    public IMouseCaptureHandle getGrabOfElement(IElement e, int mouseId) {
        for (ElementMouseCaptureHandle eh : this.mouseCaptureMap.values()) {
            if (eh.element != e || eh.mouseId() != mouseId) continue;
            return eh;
        }
        return null;
    }

    @EventHandlerReflection.EventHandler(priority=0x7FFFFFFD)
    public boolean handleMouseEvent(MouseEvent me) {
        this.assertDependencies();
        IElement currentFocus = null;
        Point2D controlPos = me.controlPosition;
        Point2D diagramPos = this.util.controlToCanvas(controlPos, null);
        PickRequest req = new PickRequest(diagramPos).context(this.getContext());
        req.pickSorter = this.pickSorter;
        ArrayList<IElement> result = new ArrayList<IElement>();
        this.pick.pick(this.diagram, req, result);
        if (result.size() > 0) {
            this._sortByOrder(result);
            currentFocus = result.get(result.size() - 1);
        }
        this.mouseFocus.put(me.mouseId, currentFocus);
        if (currentFocus == null) {
            return false;
        }
        return this.sendElementMouseEvent(currentFocus, me);
    }

    private boolean sendElementMouseEvent(IElement e, MouseEvent me) {
        for (HandleMouseEvent eh : e.getElementClass().getItemsByClass(HandleMouseEvent.class)) {
            if (!eh.handleMouseEvent(e, this.getContext(), me)) continue;
            return true;
        }
        return false;
    }

    void _sortByOrder(List<IElement> list) {
        List<IElement> elements = this.diagram.getElements();
        final HashMap<IElement, Integer> position = new HashMap<IElement, Integer>();
        for (IElement e : list) {
            position.put(e, elements.indexOf(e));
        }
        Comparator<IElement> c = new Comparator<IElement>(){

            @Override
            public int compare(IElement o1, IElement o2) {
                int pos1 = (Integer)position.get(o1);
                int pos2 = (Integer)position.get(o2);
                return pos1 - pos2;
            }
        };
        Collections.sort(list, c);
    }

    private class ElementMouseCaptureHandle
    implements IMouseCaptureHandle {
        IMouseCaptureHandle origHandle;
        IElement element;

        private ElementMouseCaptureHandle() {
        }

        @Override
        public void addMouseCaptureHandleListener(IMouseCaptureHandleListener listener) {
            this.origHandle.addMouseCaptureHandleListener(listener);
        }

        @Override
        public int mouseId() {
            return this.origHandle.mouseId();
        }

        @Override
        public void release() {
            ElementInteractor.this.mouseCaptureMap.remove(this.origHandle.mouseId());
            this.origHandle.release();
        }

        @Override
        public void removeMouseCaptureHandleListener(IMouseCaptureHandleListener listener) {
            this.origHandle.removeMouseCaptureHandleListener(listener);
        }
    }
}

