/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.g2d.diagram.impl;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.simantics.utils.datastructures.MapList;

public class AbstractHandlerClass<Handler>
implements Serializable {
    private static final long serialVersionUID = 4137854678128072467L;
    private final MapList<Class<?>, Handler> handlers = new MapList();
    private final List<Handler> snapshot;
    private final int hash;

    public AbstractHandlerClass(Collection<Handler> contributions) {
        for (Handler c : contributions) {
            this._addClass(c.getClass(), c);
        }
        this.handlers.makeImmutable();
        this.snapshot = Collections.unmodifiableList(new ArrayList<Handler>(contributions));
        this.hash = this.snapshot.hashCode();
    }

    private void _addClass(Class<?> clazz, Handler ec) {
        if (this.handlers.contains(clazz, ec)) {
            return;
        }
        this.handlers.add(clazz, ec);
        Class<?> superClazz = clazz.getSuperclass();
        if (superClazz != null) {
            this._addClass(superClazz, ec);
        }
        Class<?>[] classArray = clazz.getInterfaces();
        int n = classArray.length;
        int n2 = 0;
        while (n2 < n) {
            Class<?> interphase = classArray[n2];
            this._addClass(interphase, ec);
            ++n2;
        }
    }

    public <R extends Handler> List<R> getItemsByClass(Class<R> clazz) {
        List result = this.handlers.getValuesUnsafe(clazz);
        if (result != null) {
            return result;
        }
        return Collections.emptyList();
    }

    public <R extends Handler> R getSingleItem(Class<R> clazz) {
        List list = this.handlers.getValuesUnsafe(clazz);
        if (list == null || list.size() != 1) {
            throw new RuntimeException("Invalid element class " + this.toString() + ": One and only one " + clazz.getName() + " is expected, got " + (list != null ? list.size() : 0));
        }
        return (R)list.get(0);
    }

    public <R extends Handler> R getAtMostOneItemOfClass(Class<R> clazz) {
        List list = this.handlers.getValuesUnsafe(clazz);
        if (list == null || list.size() == 0) {
            return null;
        }
        if (list.size() == 1) {
            return (R)list.get(0);
        }
        throw new RuntimeException("At most one was " + clazz.getName() + " expected in " + this.getClass().getName() + ", got " + list.size());
    }

    public <R extends Handler> R[] getAtMostItemsOfClass(Class<R> clazz, R[] result) {
        this.handlers.getAtMostValues(clazz, (Object[])result);
        return result;
    }

    public List<Handler> getAll() {
        return this.snapshot;
    }

    public boolean contains(Handler handler) {
        return this.getAll().contains(handler);
    }

    public <R extends Handler> boolean containsClass(Class<R> clazz) {
        List list = this.handlers.getValuesUnsafe(clazz);
        if (list == null || list.size() == 0) {
            return false;
        }
        return list.size() > 0;
    }

    public int hashCode() {
        return this.hash;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AbstractHandlerClass)) {
            return false;
        }
        AbstractHandlerClass other = (AbstractHandlerClass)obj;
        return this.snapshot.equals(other.snapshot);
    }
}

