/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.g2d.chassis;

import java.awt.Color;
import java.awt.Component;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.simantics.g2d.canvas.ICanvasContext;
import org.simantics.g2d.chassis.AWTChassis;
import org.simantics.g2d.chassis.ICanvasChassis;
import org.simantics.g2d.chassis.IChassisListener;
import org.simantics.g2d.event.adapter.SWTFocusAdapter;
import org.simantics.g2d.event.adapter.SWTKeyEventAdapter;
import org.simantics.g2d.event.adapter.SWTMouseEventAdapter;
import org.simantics.utils.datastructures.hints.IHintContext;
import org.simantics.utils.threads.IThreadWorkQueue;
import org.simantics.utils.ui.SWTAWTComponent;

public class SWTChassis
extends SWTAWTComponent
implements ICanvasChassis {
    protected AWTChassis component;
    protected SWTMouseEventAdapter mouseAdapter;
    protected SWTKeyEventAdapter keyAdapter;
    protected SWTFocusAdapter focusAdapter;
    public static final IHintContext.Key KEY_SWT_COMPOSITE = new IHintContext.KeyOf(Composite.class, "SWT_COMPOSITE");
    public static final IHintContext.Key KEY_SWT_DISPLAY = new IHintContext.KeyOf(Display.class, "SWT_DISPLAY");
    public static final IHintContext.Key KEY_WORKBENCHWINDOW = new IHintContext.KeyOf(IWorkbenchWindow.class, "WORKBENCH_WINDOW");
    public static final IHintContext.Key KEY_WORKBENCHPAGE = new IHintContext.KeyOf(IWorkbenchPage.class, "WORKBENCH_PAGE");
    public static final IHintContext.Key KEY_EDITORPART = new IHintContext.KeyOf(IEditorPart.class, "EDITORPART");

    public SWTChassis(Composite parent, int style) {
        super(parent, style);
    }

    protected void doDispose() {
        if (this.component != null) {
            this.component.fireChassisClosed();
        }
        super.doDispose();
    }

    protected Component createSwingComponent() {
        this.component = new AWTChassis(false);
        return this.component;
    }

    @Override
    public void setCanvasContext(ICanvasContext canvasContext) {
        assert (this.component != null);
        if (this.component.canvasContext != null) {
            if (this.component.hintCtx != null) {
                this.component.hintCtx.removeHint(KEY_SWT_COMPOSITE);
                this.component.hintCtx.removeHint(KEY_SWT_DISPLAY);
            }
            if (this.keyAdapter != null) {
                this.removeKeyListener(this.keyAdapter);
                this.removeMouseWheelListener(this.mouseAdapter);
                this.removeMouseMoveListener(this.mouseAdapter);
                this.removeMouseTrackListener(this.mouseAdapter);
                this.removeMouseListener(this.mouseAdapter);
                this.removeFocusListener(this.focusAdapter);
            }
        }
        this.component.setCanvasContext(canvasContext);
        if (canvasContext != null) {
            if (this.component.hintCtx != null) {
                this.component.hintCtx.setHint(KEY_SWT_COMPOSITE, (Object)this);
                this.component.hintCtx.setHint(KEY_SWT_DISPLAY, (Object)this.getDisplay());
            }
            this.mouseAdapter = new SWTMouseEventAdapter((Object)canvasContext, canvasContext.getEventQueue());
            this.keyAdapter = new SWTKeyEventAdapter((Object)canvasContext, canvasContext.getEventQueue());
            this.focusAdapter = new SWTFocusAdapter((Object)canvasContext, canvasContext.getEventQueue());
            this.addKeyListener(this.keyAdapter);
            this.addMouseWheelListener(this.mouseAdapter);
            this.addMouseMoveListener(this.mouseAdapter);
            this.addMouseTrackListener(this.mouseAdapter);
            this.addMouseListener(this.mouseAdapter);
            this.addFocusListener(this.focusAdapter);
        }
    }

    public AWTChassis getAWTComponent() {
        return this.component;
    }

    @Override
    public ICanvasContext getCanvasContext() {
        return this.component.canvasContext;
    }

    @Override
    public void addChassisListener(IThreadWorkQueue thread, IChassisListener listener) {
        this.component.addChassisListener(thread, listener);
    }

    @Override
    public void removeChassisListener(IThreadWorkQueue thread, IChassisListener listener) {
        this.component.removeChassisListener(thread, listener);
    }

    @Override
    public void addChassisListener(IChassisListener listener) {
        this.component.addChassisListener(listener);
    }

    @Override
    public void removeChassisListener(IChassisListener listener) {
        this.component.removeChassisListener(listener);
    }

    @Override
    public IHintContext getHintContext() {
        return this.component.hintCtx;
    }

    public void setBackground(org.eclipse.swt.graphics.Color color) {
        super.setBackground(color);
        if (this.component != null) {
            Color awtColor = null;
            if (color != null) {
                awtColor = new Color(color.getRed(), color.getGreen(), color.getBlue());
            }
            this.component.setBackground(awtColor);
        }
    }
}

