/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.g2d.canvas.impl;

import java.awt.Cursor;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import java.util.Stack;
import org.simantics.g2d.canvas.IMouseCursorContext;
import org.simantics.g2d.canvas.IMouseCursorHandle;
import org.simantics.g2d.canvas.IMouseCursorHandleListener;
import org.simantics.g2d.canvas.IMouseCursorListener;
import org.simantics.utils.datastructures.ListenerList;
import org.simantics.utils.threads.IThreadWorkQueue;
import org.simantics.utils.threads.SyncListenerList;

public class MouseCursorContext
implements IMouseCursorContext {
    protected Map<Integer, Stack<CursorReserve>> mouseCursorStack = new HashMap<Integer, Stack<CursorReserve>>();
    protected SyncListenerList<IMouseCursorListener> cursorListeners = new SyncListenerList(IMouseCursorListener.class);
    private static final Method onCursorSet = SyncListenerList.getMethod(IMouseCursorListener.class, (String)"onCursorSet");

    @Override
    public void addCursorListener(IMouseCursorListener listener) {
        this.cursorListeners.add((Object)listener);
    }

    @Override
    public void addCursorListener(IMouseCursorListener listener, IThreadWorkQueue thread) {
        this.cursorListeners.add(thread, (Object)listener);
    }

    @Override
    public void removeCursorListener(IMouseCursorListener listener) {
        this.cursorListeners.remove((Object)listener);
    }

    @Override
    public void removeCursorListener(IMouseCursorListener listener, IThreadWorkQueue thread) {
        this.cursorListeners.remove(thread, (Object)listener);
    }

    protected void fireSetCursor(int mouseId, Cursor cursor) {
        this.cursorListeners.fireEventSync(onCursorSet, new Object[]{this, mouseId, cursor});
    }

    protected void fireAsyncSetCursor(int mouseId, Cursor cursor) {
        this.cursorListeners.fireEventAsync(onCursorSet, new Object[]{this, mouseId, cursor});
    }

    @Override
    public synchronized IMouseCursorHandle setCursor(int mouseId, Cursor cursor) {
        assert (cursor != null);
        Stack<CursorReserve> cursorStack = this.mouseCursorStack.get(mouseId);
        if (cursorStack == null) {
            cursorStack = new Stack();
            this.mouseCursorStack.put(mouseId, cursorStack);
        }
        CursorReserve cr = new CursorReserve(cursor, mouseId);
        cursorStack.push(cr);
        this._setCursor(mouseId, cursor);
        return cr;
    }

    protected void _setCursor(int mouseId, Cursor cursor) {
        this.fireAsyncSetCursor(mouseId, cursor);
    }

    class CursorReserve
    implements IMouseCursorHandle {
        Cursor cursor;
        int mouseId;
        ListenerList<IMouseCursorHandleListener> listeners;

        public CursorReserve(Cursor cursor, int mouseId) {
            this.cursor = cursor;
            this.mouseId = mouseId;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void remove() {
            MouseCursorContext mouseCursorContext = MouseCursorContext.this;
            synchronized (mouseCursorContext) {
                Stack<CursorReserve> cursorStack = MouseCursorContext.this.mouseCursorStack.get(this.mouseId);
                if (cursorStack == null || !cursorStack.contains(this)) {
                    return;
                }
                boolean wasLast = cursorStack.lastElement() == this;
                cursorStack.remove(this);
                if (cursorStack.isEmpty()) {
                    MouseCursorContext.this._setCursor(this.mouseId, null);
                    return;
                }
                if (wasLast) {
                    CursorReserve newLast = cursorStack.peek();
                    if (newLast == null) {
                        MouseCursorContext.this._setCursor(this.mouseId, null);
                    } else {
                        Cursor newCursor = newLast.cursor;
                        if (!this.cursor.equals(newCursor)) {
                            MouseCursorContext.this._setCursor(this.mouseId, newCursor);
                        }
                    }
                }
            }
        }

        @Override
        public Cursor getCursor() {
            return this.cursor;
        }

        @Override
        public int getMouseId() {
            return this.mouseId;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void fireOnRemoved() {
            ListenerList<IMouseCursorHandleListener> lis;
            CursorReserve cursorReserve = this;
            synchronized (cursorReserve) {
                lis = this.listeners;
                if (lis == null) {
                    return;
                }
            }
            IMouseCursorHandleListener[] iMouseCursorHandleListenerArray = (IMouseCursorHandleListener[])lis.getListeners();
            int n = iMouseCursorHandleListenerArray.length;
            int n2 = 0;
            while (n2 < n) {
                IMouseCursorHandleListener l = iMouseCursorHandleListenerArray[n2];
                l.onMouseCursorRemoved(this);
                ++n2;
            }
        }

        @Override
        public synchronized void addMouseCursorHandleListener(IMouseCursorHandleListener listener) {
            if (this.listeners == null) {
                this.listeners = new ListenerList(IMouseCursorHandleListener.class);
            }
            this.listeners.add((Object)listener);
        }

        @Override
        public synchronized void removeMouseCursorHandleListener(IMouseCursorHandleListener listener) {
            if (this.listeners == null) {
                return;
            }
            this.listeners.remove((Object)listener);
        }
    }
}

