/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.g2d.canvas.impl;

import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collection;
import org.simantics.g2d.canvas.ICanvasParticipant;
import org.simantics.g2d.diagram.handler.DiagramHandler;

public class DependencyReflection {
    private static final ReferenceDefinition[] EMPTY = new ReferenceDefinition[0];

    public static ReferenceDefinition[] getDependencies(Object obj, ReferenceType type) {
        ArrayList<ReferenceDefinition> result = new ArrayList<ReferenceDefinition>();
        Class<?> clazz = obj.getClass();
        DependencyReflection._addDependencies(clazz, result, type);
        return result.toArray(EMPTY);
    }

    private static void _addDependencies(Class<?> clazz, Collection<ReferenceDefinition> result, ReferenceType type) {
        Field[] fieldArray = clazz.getDeclaredFields();
        int n = fieldArray.length;
        int n2 = 0;
        while (n2 < n) {
            Field f = fieldArray[n2];
            Class<?> c = f.getType();
            Dependency dep = f.getAnnotation(Dependency.class);
            Reference ref = f.getAnnotation(Reference.class);
            if (dep != null || ref != null) {
                ReferenceType referenceType = null;
                if (ICanvasParticipant.class.isAssignableFrom(c)) {
                    referenceType = ReferenceType.CanvasParticipant;
                } else if (DiagramHandler.class.isAssignableFrom(c)) {
                    referenceType = ReferenceType.DiagramHandler;
                } else assert (false);
                if (referenceType == type) {
                    assert (dep == null || ref == null);
                    ReferenceDefinition rd = new ReferenceDefinition();
                    rd.dependency = dep != null;
                    rd.field = f;
                    rd.requirement = c;
                    rd.referenceType = referenceType;
                    f.setAccessible(true);
                    result.add(rd);
                }
            }
            ++n2;
        }
        Class<?> superClass = clazz.getSuperclass();
        if (superClass != null) {
            DependencyReflection._addDependencies(superClass, result, type);
        }
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.FIELD})
    public static @interface Dependency {
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.FIELD})
    public static @interface Reference {
    }

    public static final class ReferenceDefinition {
        public Class<?> requirement;
        public Field field;
        public boolean dependency;
        public ReferenceType referenceType;
    }

    public static enum ReferenceType {
        CanvasParticipant,
        DiagramHandler;

    }
}

