/*******************************************************************************
 * Copyright (c) 2007, 2010 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.g2d.utils.geom;

import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.PathIterator;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.Arrays;

/**
 * Describes a line segment, either linear, quadratic or cubic
 * 
 * @author Toni Kalajainen
 */
public class LineSegment implements Shape {
    private double line[];
    public LineSegment(double x0, double y0, double x1, double y1)
    {
        line = new double[] {x0, y0, x1, y1};
    }
    public LineSegment(double x0, double y0, double x1, double y1, double x2, double y2)
    {
        line = new double[] {x0, y0, x1, y1, x2, y2};
    }
    public LineSegment(double x0, double y0, double x1, double y1, double x2, double y2, double x3, double y3)
    {
        line = new double[] {x0, y0, x1, y1, x2, y2, x3, y3};
    }
    public LineSegment(double data[])
    {
        assert(data.length==4 || data.length==6 || data.length==8);
        line = Arrays.copyOf(data, data.length);
    }
    public double[] getLine() {
        return line;
    }
    public int getDegree() {
        return (line.length-2)/2;
    }
    public Point2D getStartPos(Point2D pt)
    {
        if (pt==null) return new Point2D.Double(line[0], line[1]);
        pt.setLocation(line[0], line[1]);
        return pt;
    }
    public Point2D getEndPos(Point2D pt)
    {
        int p = line.length-2;
        if (pt==null) return new Point2D.Double(line[p], line[p+1]);
        pt.setLocation(line[p], line[p+1]);
        return pt;
    }
    public void setData(double data[])
    {
        assert(data.length==4 || data.length==6 || data.length==8);
        line = Arrays.copyOf(data, data.length);
    }



    @Override
    public boolean contains(Point2D p) {
        return false;
    }
    @Override
    public boolean contains(Rectangle2D r) {
        return false;
    }
    @Override
    public boolean contains(double x, double y) {
        return false;
    }
    @Override
    public boolean contains(double x, double y, double w, double h) {
        return false;
    }
    @Override
    public Rectangle getBounds() {
        return null;
    }
    @Override
    public Rectangle2D getBounds2D() {
        return null;
    }
    @Override
    public PathIterator getPathIterator(AffineTransform at) {
        return null;
    }
    @Override
    public PathIterator getPathIterator(AffineTransform at, double flatness) {
        return null;
    }
    @Override
    public boolean intersects(Rectangle2D r) {
        return false;
    }
    @Override
    public boolean intersects(double x, double y, double w, double h) {
        return false;
    }
}

