/*******************************************************************************
 * Copyright (c) 2007, 2010 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.g2d.utils;

import java.awt.Font;

import org.eclipse.jface.resource.FontRegistry;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.ui.PlatformUI;
import org.simantics.utils.ui.SWTDPIUtil;

public final class FontHelper {

    /**
     * @return
     * @throws IllegalStateException if there's no eclipse workbench context
     *         available
     */
    public static FontRegistry getCurrentThemeFontRegistry() {
        return PlatformUI.getWorkbench().getThemeManager().getCurrentTheme().getFontRegistry();
    }

    public static java.awt.Font toAwt(FontRegistry registry, String themeFontId) {
        FontData fd = registry.getFontData(themeFontId)[0];
        return toAwt(fd);
    }

    public static java.awt.Font toAwt(FontData fd) {
        int awtFontSize = SWTDPIUtil.upscaleSwt(fd.getHeight());
        // The style constants for SWT and AWT map exactly, and since they are int constants, they should
        // never change. So, the SWT style is passed through as the AWT style.
        Font font = new java.awt.Font(fd.getName(), fd.getStyle(), awtFontSize);
//        System.out.println("awt font: " + font);
        return font;
    }

}
