/*******************************************************************************
 * Copyright (c) 2007, 2010 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.g2d.tooltip;

import java.awt.Frame;
import java.awt.Label;

import org.simantics.g2d.element.IElement;
/**
 * Simple tool-tip showing a label
 * 
 * @author Marko Luukkainen <marko.luukkainen@vtt.fi>
 *
 */
public abstract class TextTooltipProvider implements TooltipProvider {
	private Frame frame;
	
	@Override
	public void showTooltip(IElement element, int x, int y) {
		frame = new Frame(getTooltipText(element));
		frame.setFocusableWindowState(false);
		frame.setUndecorated(true);
		Label label = new Label(getTooltipText(element));
		frame.add(label);
		frame.pack();
		frame.setVisible(true);
		frame.setLocation(x,y-32);
	}
	
	@Override
	public void hideTooltip(IElement element) {
		frame.setVisible(false);
		frame.dispose();
		frame = null;
	}
	
	public abstract String getTooltipText(IElement element);
}
