/*******************************************************************************
 * Copyright (c) 2007, 2010 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.g2d.tooltip;

import java.awt.geom.Point2D;

import org.simantics.g2d.canvas.impl.DependencyReflection.Dependency;
import org.simantics.g2d.diagram.participant.pointertool.PointerInteractor;
import org.simantics.g2d.diagram.participant.pointertool.TerminalUtil.TerminalInfo;
import org.simantics.g2d.element.ElementHints;
import org.simantics.g2d.element.handler.TerminalData;
import org.simantics.scenegraph.g2d.events.EventHandlerReflection.EventHandler;
import org.simantics.scenegraph.g2d.events.MouseEvent.MouseMovedEvent;
import org.simantics.utils.datastructures.hints.IHintContext.Key;
import org.simantics.utils.datastructures.hints.IHintContext.KeyOf;


/**
 * TooltipParticipan that is able to show terminal tooltips
 * 
 * Note: this participant does not co-operate with TooltipParticipant.
 * 
 * 
 * @author Marko Luukkainen <marko.luukkainen@vtt.fi>
 *
 */
public class TerminalTooltipParticipant extends BaseTooltipParticipant {

    public static final Key KEY_TOOLTIP_TEXT = new KeyOf(String.class, "TERMINAL_TOOLTIP_TEXT");

    @Dependency PointerInteractor interactor;

    @EventHandler(priority = 0)
    public boolean handleMove(MouseMovedEvent me) {
        update(me.controlPosition);
        return false;
    }

    private void update(Point2D controlPos) {
        TerminalInfo info = interactor.pickTerminal(controlPos);

        if (info != null) {
            TerminalData data = info.e.getElementClass().getAtMostOneItemOfClass(TerminalData.class);
            if (data == null)
                return;

            String text = data.getHint(info.e, info.t, ElementHints.KEY_TEXT);
            // this is not a really good way to provide terminal name
            info.e.setHint(KEY_TOOLTIP_TEXT, text);
            showTooltipFor(info.e);
        } else
            hideTooltip();
    }

}
