/*******************************************************************************
 * Copyright (c) 2007, 2010 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.g2d.tooltip;

import java.awt.Frame;
import java.awt.Label;
import java.awt.TextField;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;

import javax.swing.BoxLayout;

import org.simantics.g2d.element.IElement;

public abstract class EditableTextTooltipProvider implements FocusableTooltipProvider {
	private Frame frame;
	private TextField field;
	
	@Override
	public void showTooltip(final IElement element, int x, int y) {
		if (frame != null) {
			frame.setVisible(false);
			frame.dispose();
			frame = null;
		}
		frame = new Frame(getTooltipText(element));
		frame.setFocusableWindowState(false);
		frame.setUndecorated(true);
		frame.addFocusListener(new FocusListener() {
			
			@Override
			public void focusLost(FocusEvent arg0) {
				System.out.println("Lost " + arg0);
				
			}
			
			@Override
			public void focusGained(FocusEvent arg0) {
				System.out.println("Lost " + arg0);	
			}
		});
		Label label = new Label("Press 'F9' to focus");
		field = new TextField(getTooltipText(element));
		field.setFocusable(false);
		field.setEditable(false);
		field.addKeyListener(new KeyListener() {
			
			@Override
			public void keyTyped(KeyEvent arg0) {
				
			}
			
			@Override
			public void keyReleased(KeyEvent arg0) {
				if (arg0.getKeyCode() == KeyEvent.VK_ENTER) {
					setText(element, field.getText());
					frame.setVisible(false);
				}
			}
			
			@Override
			public void keyPressed(KeyEvent arg0) {
				
			}
		});
		frame.setLayout(new BoxLayout(frame, BoxLayout.Y_AXIS));
		frame.add(label);
		frame.add(field);
		frame.pack();
		frame.setVisible(true);
		frame.setLocation(x,y-32);
		
	}
	
	@Override
	public void hideTooltip(IElement element) {
		if (frame != null) {
			frame.setVisible(false);
			frame.dispose();
			frame = null;
		}
	}
	
	public void focus() {
		frame.setFocusableWindowState(true);
		frame.setFocusable(true);
		field.setFocusable(true);
		field.setEditable(true);
		frame.requestFocus();
		frame.requestFocusInWindow();
		//frame.transferFocus();
		System.out.println(field.isFocusOwner() + " " + frame.isFocused());
	}
	
	@Override
	public boolean hasFocus() {
		return field.isFocusOwner();
	}
	
	public abstract String getTooltipText(IElement element);
	
	public abstract void setText(IElement element, String text);

}
