/*******************************************************************************
 * Copyright (c) 2007, 2010 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.g2d.svg;

//import static org.apache.batik.util.SVGConstants.SVG_NONE_VALUE;
//
//import org.apache.batik.util.CSSConstants;

/**
 * @author Tuukka Lehtonen
 */
public class FillDesc {

//    public static final FillDesc NO_FILL = new FillDesc(SVG_NONE_VALUE) {
//        @Override
//        public String toStyleString() {
//            return "fill:none;";
//        }
//        @Override
//        public void setFillRule(FillRule rule) {
//            throw new UnsupportedOperationException("immutable object");
//        }
//        @Override
//        public void setOpacity(double opacity) {
//            throw new UnsupportedOperationException("immutable object");
//        }
//        @Override
//        public void setPaint(String paint) {
//            throw new UnsupportedOperationException("immutable object");
//        }
//    };


    //private static final String[] ruleConv      = { "nonzero", "evenodd" };

    /**
     * paint | inherit
     */
    private String paint;

    /**
     * [0,1] | "inherit"
     */
    private double opacity;

    /**
     * nonzero | evenodd | inherit
     */
    private FillRule fillRule;

    
    public FillDesc() {
        this(StyleConstants.INHERIT, 1, FillRule.nonzero);
    }
    
    public FillDesc(String paint) {
        this(paint, 1, FillRule.nonzero);
    }
    
    public FillDesc(String paint, double opacity) {
        this(paint, opacity, FillRule.nonzero);
    }
    
    public FillDesc(String paint, double opacity, FillRule fillRule) {
        this.paint = paint;
        this.opacity = opacity;
        this.fillRule = fillRule != null ? fillRule : FillRule.nonzero;
    }

    public String getPaint() {
        return paint;
    }
    
    public void setPaint(String paint) {
        this.paint = paint;
    }
    
    public double getOpacity() {
        return opacity;
    }
    
    public void setOpacity(double opacity) {
        this.opacity = opacity;
    }
    
    public FillRule getFillRule() {
        return fillRule;
    }
    
    public void setFillRule(FillRule rule) {
        this.fillRule = rule;
    }
    
    /**
     * Returns the hashcode for this stroke.
     * 
     * @return a hash code for this stroke.
     */
    public int hashCode() {
        int hash = paint.hashCode();
        hash = hash * 31 + (int) Double.doubleToLongBits(opacity);
        hash = hash * 31 + fillRule.hashCode();
        return hash;
    }

    /**
     * Returns true if this BasicStroke represents the same stroking operation
     * as the given argument.
     * 
     * <p>
     * Tests if a specified object is equal to this <code>Stroke</code> by
     * first testing if it is a <code>BasicStroke</code> and then comparing
     * its width, join, cap, miter limit, dash, and dash phase attributes with
     * those of this <code>Stroke</code>.
     * 
     * @param obj the specified object to compare to this <code>Stroke</code>
     * @return <code>true</code> if the width, join, cap, miter limit, dash,
     *         and dash phase are the same for both objects; <code>false</code>
     *         otherwise.
     */
    public boolean equals(Object obj) {
        if (!(obj instanceof FillDesc)) {
            return false;
        }

        FillDesc fd = (FillDesc) obj;
        if (opacity != fd.opacity) {
            return false;
        }
        if (!fillRule.equals(fd.fillRule)) {
            return false;
        }
        return true;
    }
    
//    public String toStyleString() {
//        StringBuilder s = new StringBuilder(64);
//        
//        s.append(CSSConstants.CSS_FILL_PROPERTY);
//        s.append(':');
//        s.append(paint);
//        s.append(';');
//        if (!paint.equals(CSSConstants.CSS_NONE_VALUE)) {
//            s.append(CSSConstants.CSS_FILL_OPACITY_PROPERTY);
//            s.append(':');
//            s.append(opacity);
//            s.append(';');
//            s.append(CSSConstants.CSS_FILL_RULE_PROPERTY);
//            s.append(':');
//            s.append(fillRule);
//            s.append(';');
//        }
//        
//        return s.toString();
//    }
    
}
