/*******************************************************************************
 * Copyright (c) 2007, 2010 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.g2d.routing.algorithm1;

import java.awt.geom.Rectangle2D;

public class Rectangle {
    final public double x0, y0, x1, y1;

    public Rectangle(double x0, double y0, double x1, double y1) {
        this.x0 = x0;
        this.y0 = y0;
        this.x1 = x1;
        this.y1 = y1;
    }

    public boolean intersects(Rectangle rect) {
        return x0 <= rect.x1 && rect.x0 <= x1 && y0 <= rect.y1 && rect.y0 <= y1;
    }

    public boolean contains(double x, double y) {
        return x0 <= x && x <= x1 && y0 <= y && y <= y1;
    }

    public static Rectangle of(Rectangle2D rect) {
        return new Rectangle(rect.getMinX(), rect.getMinY(), rect.getMaxX(), rect.getMaxY());
    }

    @Override
    public String toString() {
        return getClass().getSimpleName()
        + "[x0=" + x0 +
        ",y0=" + y0 +
        ",x1=" + x1 +
        ",y1=" + y1 + "]";
    }

}
