/*******************************************************************************
 * Copyright (c) 2007, 2010 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.g2d.routing.algorithm1;

import org.simantics.g2d.routing.algorithm1.StaticRouter.Cost;

public class Penalty {
	static final double BEND_PENALTY = 1.0;
	static final double CONNECTION_MARGINAL = 10.0;
	static final Cost INFINITE_COST = new Cost(Double.POSITIVE_INFINITY, Double.POSITIVE_INFINITY);
	
	static final Penalty OBSTACLE_PENALTY = new Penalty(20.0, 0.0);
	static final Penalty CONNECTION_SIDE_PENALTY = new Penalty(10.0, 0.0);
	static final Penalty CONNECTION_CROSS_PENALTY = new Penalty(0.4, 2*CONNECTION_MARGINAL);
	
	double penalty;
	double minDistance;	
	
	public Penalty(double penalty, double minDistance) {
		this.penalty = penalty;
		this.minDistance = minDistance;
	}
	
	@Override
	public int hashCode() {
		final int prime = 31;
		int result = 1;
		long temp;
		temp = Double.doubleToLongBits(minDistance);
		result = prime * result + (int) (temp ^ (temp >>> 32));
		temp = Double.doubleToLongBits(penalty);
		result = prime * result + (int) (temp ^ (temp >>> 32));
		return result;
	}
	@Override
	public boolean equals(Object obj) {
		if (this == obj)
			return true;
		if (obj == null)
			return false;
		if (getClass() != obj.getClass())
			return false;
		Penalty other = (Penalty) obj;
		if (Double.doubleToLongBits(minDistance) != Double
			.doubleToLongBits(other.minDistance))
			return false;
		if (Double.doubleToLongBits(penalty) != Double
			.doubleToLongBits(other.penalty))
			return false;
		return true;
	}
	
	
}
