/*******************************************************************************
 * Copyright (c) 2007, 2010 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.g2d.routing;

import java.awt.geom.Path2D;

import org.simantics.g2d.routing.IConnection.Connector;

public class TrivialRouter2 implements IRouter2 {

    public static final TrivialRouter2 INSTANCE = new TrivialRouter2();

    @Override
    public void route(IConnection connection) {
        for (Object seg : connection.getSegments()) {
            Connector begin = connection.getBegin(seg);
            Connector end = connection.getEnd(seg);

            Path2D path = new Path2D.Double();
            path.moveTo(begin.x, begin.y);
            path.lineTo(end.x, end.y);
            connection.setPath(seg, path);
        }
    }

}
