/*******************************************************************************
 * Copyright (c) 2007, 2010 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.g2d.routing;

import java.awt.geom.Path2D;

public class TrivialRouter implements IRouter {

    @Override
    public void update(IGraphModel model) {
        for(Object c : model.getConnections()) {
            Terminal begin = model.getBeginTerminal(c);            
            Terminal end = model.getEndTerminal(c);
            double[] routePoints = model.getRoutePoints(c);
            
            Path2D path = new Path2D.Double();
            int i=0;
            if(begin != null)
                path.moveTo(begin.x, begin.y);
            else if(routePoints.length >= 2) {
                path.moveTo(routePoints[0], routePoints[1]);
                i = 2;
            }
            for(;i<routePoints.length;i += 2)
                path.lineTo(routePoints[i], routePoints[i+1]);
            if(end != null)
                path.lineTo(end.x, end.y);
            
            model.setPath(c, path);
        }
    }

}
