/*******************************************************************************
 * Copyright (c) 2007, 2010 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.g2d.routing;

import java.awt.geom.Rectangle2D;
import java.util.Arrays;

public class Terminal {
	public static final double[] ZEROS = new double[] { 0.0, 0.0, 0.0, 0.0 };
	
	public double x;
	public double y;
	public int directions;
	public double[] minDist;
	public Rectangle2D parentObstacle;
	
	public Terminal(double x, double y, int directions, double[] minDist,
	    Rectangle2D parentObstacle) {
		this.x = x;
		this.y = y;
		this.directions = directions;
		this.minDist = minDist;
		this.parentObstacle = parentObstacle;
	}

	@Override
	public int hashCode() {
		final int prime = 31;
		int result = 1;
		result = prime * result + directions;
		result = prime * result + Arrays.hashCode(minDist);
		long temp;
		temp = Double.doubleToLongBits(x);
		result = prime * result + (int) (temp ^ (temp >>> 32));
		temp = Double.doubleToLongBits(y);
		result = prime * result + (int) (temp ^ (temp >>> 32));
		return result;
	}

	@Override
	public boolean equals(Object obj) {
		if (this == obj)
			return true;
		if (obj == null)
			return false;
		if (getClass() != obj.getClass())
			return false;
		Terminal other = (Terminal) obj;
		if (directions != other.directions)
			return false;
		if (!Arrays.equals(minDist, other.minDist))
			return false;
		if (Double.doubleToLongBits(x) != Double.doubleToLongBits(other.x))
			return false;
		if (Double.doubleToLongBits(y) != Double.doubleToLongBits(other.y))
			return false;
		return true;
	}	
	
	
	
}
