/*******************************************************************************
 * Copyright (c) 2007, 2010 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.g2d.routing;

import org.simantics.g2d.routing.algorithm2.Router4;


public class RouterFactory {

    public static IRouter2 create(boolean autoroute) {
        if (autoroute)
            return new Router4(true);
        else
            return new TrivialRouter2();
    }

    public static IRouter2 create(boolean autoroute, boolean roundCorners) {
        if (autoroute)
            return new Router4(roundCorners);
        else
            return new TrivialRouter2();
    }

}
