/*******************************************************************************
 * Copyright (c) 2007, 2010 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.g2d.routing;


public class Constants {	
	static public final int EAST = 0;
	static public final int SOUTH = 1;
	static public final int WEST = 2;
	static public final int NORTH = 3;
		
	static public final int EAST_FLAG = 1 << EAST;
	static public final int SOUTH_FLAG = 1 << SOUTH;
	static public final int WEST_FLAG = 1 << WEST;
	static public final int NORTH_FLAG = 1 << NORTH;
	
	static public final int POSSIBLE_DIRECTIONS[][] = {
		new int[] {},
		new int[] { EAST },
		new int[] { SOUTH },
		new int[] { EAST, SOUTH },
		new int[] { WEST },
		new int[] { EAST, WEST },
		new int[] { SOUTH, WEST },
		new int[] { EAST, SOUTH, WEST },
		new int[] { NORTH },
		new int[] { EAST, NORTH },
		new int[] { SOUTH, NORTH },
		new int[] { EAST, SOUTH, NORTH },
		new int[] { WEST, NORTH },
		new int[] { EAST, WEST, NORTH },
		new int[] { SOUTH, WEST, NORTH },
		new int[] { EAST, SOUTH, WEST, NORTH }
	};
}
