/*******************************************************************************
 * Copyright (c) 2007, 2010 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.g2d.routing;

import java.awt.geom.Rectangle2D;
import java.util.Arrays;

import org.simantics.g2d.routing.IConnection.Connector;

public class ConnectionDirectionUtil {
	
	public static class Dir implements Comparable<Dir> {
		int id;
		double dist;
		
		public Dir(int id, double dist) {
			this.id = id;
			this.dist = dist;
		}

		@Override
		public int compareTo(Dir o) {
			if(dist < o.dist)
				return -1;
			if(o.dist < dist)
				return 1;
			return 0;
		}	
		
	}
	
	public static Terminal createTerminal(Rectangle2D shape, double x, double y) {
		Dir[] dirs = new Dir[] {
			new Dir(0, shape.getMaxX() - x),
			new Dir(1, shape.getMaxY() - y),
			new Dir(2, x - shape.getMinX()),
			new Dir(3, y - shape.getMinY()),
		};
		Arrays.sort(dirs);
		double[] dist = new double[4];
		int flags = 0;
		int i=0;
		do {
			flags |= 1 << dirs[i].id;
			dist[dirs[i].id] = Math.max(0.0, dirs[i].dist+1e-6);
			++i;
		} while(i < 4 && (dirs[i].dist <= 0.0 || dirs[i].dist*0.9 < dirs[0].dist));
		return new Terminal(x, y, flags, dist, shape);
	}
	
	public static int reverseDirections(int flags) {
		return ((flags & Constants.EAST_FLAG) == 0 ? 0 : Constants.WEST_FLAG)
			 | ((flags & Constants.SOUTH_FLAG) == 0 ? 0 : Constants.NORTH_FLAG)
			 | ((flags & Constants.WEST_FLAG) == 0 ? 0 : Constants.EAST_FLAG)
			 | ((flags & Constants.NORTH_FLAG) == 0 ? 0 : Constants.SOUTH_FLAG);
	}
	
	public static void determineAllowedDirections(Connector c) {
	    if(c.parentObstacle == null) {
	        c.allowedDirections = 0xf;
	        return;
	    }
	    Dir[] dirs = new Dir[] {
            new Dir(0, c.parentObstacle.getMaxX() - c.x),
            new Dir(1, c.parentObstacle.getMaxY() - c.y),
            new Dir(2, c.x - c.parentObstacle.getMinX()),
            new Dir(3, c.y - c.parentObstacle.getMinY()),
        };
        Arrays.sort(dirs);
        double[] dist = new double[4];
        c.allowedDirections = 0;
        int i=0;
        do {
            c.allowedDirections |= 1 << dirs[i].id;
            dist[dirs[i].id] = Math.max(0.0, dirs[i].dist+1e-6);
            ++i;
        } while(i < 4 &&
        		((dirs[i].id == ((dirs[0].id + 2)&3) && (dirs[i].dist <= 0.0 || dirs[i].dist*0.9 < dirs[0].dist)) ||
        		(dirs[i].dist <= 0.0 || dirs[i].dist*0.95 < dirs[0].dist))
        		);
	}
}
