/*******************************************************************************
 * Copyright (c) 2007, 2010 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.g2d.participant;

import java.awt.geom.Rectangle2D;

import org.simantics.g2d.canvas.Hints;
import org.simantics.g2d.canvas.ICanvasContext;
import org.simantics.g2d.canvas.impl.AbstractCanvasParticipant;
import org.simantics.g2d.canvas.impl.SGNodeReflection.SGCleanup;
import org.simantics.g2d.canvas.impl.SGNodeReflection.SGInit;
import org.simantics.scenegraph.g2d.G2DParentNode;
import org.simantics.scenegraph.g2d.nodes.PageBorderNode;
import org.simantics.utils.datastructures.hints.HintListenerAdapter;
import org.simantics.utils.datastructures.hints.IHintContext.Key;
import org.simantics.utils.datastructures.hints.IHintListener;
import org.simantics.utils.datastructures.hints.IHintObservable;
import org.simantics.utils.page.MarginUtils.Margins;
import org.simantics.utils.page.PageDesc;

/**
 * Paints borders or a page according to Page
 *
 * @author Tuukka Lehtonen
 */
public class PageBorderParticipant extends AbstractCanvasParticipant {

    IHintListener hintListener = new HintListenerAdapter() {
        @Override
        public void hintChanged(IHintObservable sender, Key key, Object oldValue, Object newValue) {
            if (key == Hints.KEY_PAGE_DESC) {
                //System.out.println("PAGE DESC CHANGED FROM " + oldValue + " to " + newValue);
                updateNode(true);
            } else if (key == Hints.KEY_DISPLAY_PAGE) {
                //System.out.println("DISPLAY PAGE CHANGED: " + oldValue + " TO " + newValue);
                updateNode(true);
            } else if (key == Hints.KEY_DISPLAY_MARGINS) {
                //System.out.println("DISPLAY MARGINS CHANGED: " + oldValue + " TO " + newValue);
                updateNode(true);
            } else if (key == Hints.KEY_DISABLE_PAINTING) {
                updateNode(true);
            }
        }
    };

    @Override
    public void addedToContext(ICanvasContext ctx) {
        super.addedToContext(ctx);
        getHintStack().addKeyHintListener(getThread(), Hints.KEY_PAGE_DESC, hintListener);
        getHintStack().addKeyHintListener(getThread(), Hints.KEY_DISPLAY_PAGE, hintListener);
        getHintStack().addKeyHintListener(getThread(), Hints.KEY_DISPLAY_MARGINS, hintListener);
        getHintStack().addKeyHintListener(getThread(), Hints.KEY_DISABLE_PAINTING, hintListener);
    }

    @Override
    public void removedFromContext(ICanvasContext ctx) {
        getHintStack().removeKeyHintListener(getThread(), Hints.KEY_PAGE_DESC, hintListener);
        getHintStack().removeKeyHintListener(getThread(), Hints.KEY_DISPLAY_PAGE, hintListener);
        getHintStack().removeKeyHintListener(getThread(), Hints.KEY_DISPLAY_MARGINS, hintListener);
        getHintStack().removeKeyHintListener(getThread(), Hints.KEY_DISABLE_PAINTING, hintListener);
        super.removedFromContext(ctx);
    }

    protected void updateNode(boolean markDirty) {
        boolean displayPage = !Boolean.FALSE.equals(getHint(Hints.KEY_DISPLAY_PAGE));
        boolean displayMargins = !Boolean.FALSE.equals(getHint(Hints.KEY_DISPLAY_MARGINS));
        boolean enabled = !Boolean.TRUE.equals(getHint(Hints.KEY_DISABLE_PAINTING));

        Rectangle2D border = new Rectangle2D.Double();
        Rectangle2D margin = new Rectangle2D.Double();

        PageDesc desc = getHint(Hints.KEY_PAGE_DESC);
        //System.out.println("updateNode: " + desc + ", " + displayPage + ", " + displayMargins);
        if (desc != null) {
            if (displayPage)
                desc.getPageRectangle(border);

            Margins margins = desc.getMargins();
            boolean marginsZero = margins.isZero();
            //System.out.println("Margins: " + margins + ": zero: " + marginsZero);
            if (displayMargins && !marginsZero) {
                double mlx = desc.getLeftEdgePos() + margins.left.diagramAbsolute;
                double mty = desc.getTopEdgePos() + margins.top.diagramAbsolute;
                double w = desc.getOrientedWidth() - (margins.left.diagramAbsolute + margins.right.diagramAbsolute);
                double h = desc.getOrientedHeight() - (margins.top.diagramAbsolute + margins.bottom.diagramAbsolute);
                margin.setFrame(mlx, mty, w, h);
            }
        }

        node.init(border, margin, enabled);

        if (markDirty)
            setDirty();
    }

    protected PageBorderNode node = null;

    @SGInit
    public void initSG(G2DParentNode parent) {
        node = parent.addNode("page border", PageBorderNode.class);
        node.setZIndex(-1000);
        updateNode(false);
    }

    @SGCleanup
    public void cleanupSG() {
        node.remove();
    }
}
