/*******************************************************************************
 * Copyright (c) 2007, 2010 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.g2d.page;

import java.io.IOException;
import java.io.Serializable;
import java.io.StreamCorruptedException;

import org.simantics.utils.page.PageCentering;
import org.simantics.utils.page.PageDesc;
import org.simantics.utils.page.PageOrientation;

/**
 * A serializable wrapper for {@link PageDesc}.
 */
public class SerializablePageDesc implements Serializable {

    private static final long               serialVersionUID = -1992775876802871858L;

    private transient PageDesc desc;

    public SerializablePageDesc(PageDesc desc) {
        this.desc = desc;
    }

    public PageDesc getDesc() {
        return desc;
    }

    @Override
    public String toString() {
        return String.format("%s [%s]", getClass().getSimpleName(), desc.toString());
    }

    private void writeObject(java.io.ObjectOutputStream out) throws IOException {
        out.defaultWriteObject();
        out.writeUTF(desc.getText());
        out.writeDouble(desc.getWidth());
        out.writeDouble(desc.getHeight());
        out.writeByte(desc.getOrientation().ordinal());
        out.writeByte(desc.getCentering().ordinal());
    }

    private void readObject(java.io.ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        String text = in.readUTF();
        double widthInMM = in.readDouble();
        double heightInMM = in.readDouble();
        byte o = in.readByte();
        byte c = in.readByte();
        PageOrientation[] orientations = PageOrientation.values();
        if (o < 0 || o >= orientations.length)
            throw new StreamCorruptedException("invalid orientation: " + o);
        PageOrientation orientation = orientations[o];
        PageCentering[] centerings = PageCentering.values();
        if (c < 0 || c >= centerings.length)
            throw new StreamCorruptedException("invalid centering: " + c);
        PageCentering centering = centerings[c];

        desc = new PageDesc(text, orientation, centering, widthInMM, heightInMM);
    }

}
