/*******************************************************************************
 * Copyright (c) 2007, 2010 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.g2d.notification;

import java.awt.Font;

import org.simantics.g2d.image.Image;
import org.simantics.scenegraph.g2d.G2DParentNode;
import org.simantics.scenegraph.g2d.nodes.MessageNotificationNode;

/**
 * @author Tuukka Lehtonen
 */
public class MessageNotification extends AbstractNotification {

    private static final double MARGIN = 10;

    String                      message;
    Image                       image;

    //Font                        font   = new Font("Arial Black", Font.PLAIN, 16);
    Font                        font   = new Font("Arial", Font.PLAIN, 14);
    //Font                        font   = new Font("Segoe UI", Font.PLAIN, 14);

    public MessageNotification(String message) {
        this(message, null);
    }

    public MessageNotification(String message, Image image) {
        this.message = message;
        this.image = image;
    }

    @Override
    public void update(G2DParentNode parent) {
        MessageNotificationNode node = parent.getOrCreateNode("" + hashCode(), MessageNotificationNode.class);
        node.init(bounds, font, MARGIN, progress, message);
    }

}
