/*******************************************************************************
 * Copyright (c) 2007, 2010 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.g2d.notification;

import java.awt.geom.Rectangle2D;

/**
 * @author Tuukka Lehtonen
 */
public abstract class AbstractNotification implements INotification {

    protected Rectangle2D bounds = new Rectangle2D.Double();
    protected long        creationTime;
    protected double      progress;

    public AbstractNotification() {
        this.creationTime = System.currentTimeMillis();
    }

    @Override
    public long getCreationTime() {
        return creationTime;
    }

//    @Override
//    public Rectangle2D getBounds(Graphics2D g) {
//        return bounds;
//    }

    @Override
    public void setBounds(Rectangle2D r) {
        this.bounds.setFrame(r);
    }

    @Override
    public void setProgress(double p) {
        this.progress = p;
    }

    @Override
    public int compareTo(INotification o) {
        long delta = getCreationTime() - o.getCreationTime();
        return delta < 0 ? -1 : delta > 0 ? 1 : 0;
    }

    @Override
    public String toString() {
        return getClass().getSimpleName() + "[" + creationTime + ", progress=" + progress + "]";
    }

}