/*******************************************************************************
 * Copyright (c) 2007, 2010 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.g2d.multileveldiagram;

import org.simantics.g2d.element.handler.impl.TransitionFunctionPainter;

/**
 * Transition function 
 * - Bijective function 
 * 
 * @See {@link TransitionFunctionPainter}
 * @author Toni Kalajainen
 */
public interface TransitionFunction {
	
	public static final TransitionFunction LINEAR = 
		new TransitionFunction() {
			@Override
			public double f(double p) {
				return p;
			}};
	public static final TransitionFunction SIGMOID = 
		new TransitionFunction() {
			@Override
			public double f(double p) {
				return 1 / (1+ Math.exp(6-p*12));
			}};
	
	/**
	 * Calculates transition value
	 * @param p 0..1
	 * @return 0..1
	 */
	double f(double p);

}
