/*******************************************************************************
 * Copyright (c) 2007, 2010 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.g2d.layers;

import java.util.concurrent.CopyOnWriteArrayList;

/**
 * @author Antti Villberg
 */
public class SimpleLayer implements IEditableLayer {

    private CopyOnWriteArrayList<ILayerListener> listeners = new CopyOnWriteArrayList<ILayerListener>();

    private String name;

    public SimpleLayer(String name) {
        if (name == null)
            throw new IllegalArgumentException("null name");
        this.name = name;
    }

    @Override
    public String getName() {
        return name;
    }

    @Override
    public void setName(String name) {
        if (name == null)
            throw new IllegalArgumentException("null name");
        String oldName = this.name;
        this.name = name;
        if (!name.equals(oldName)) {
            fireLayerChanged(new LayerChangeEvent(this, PROP_NAME, oldName, name));
        }
    }

    @Override
    public int hashCode() {
        return name.hashCode();
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj)
            return true;
        if (obj == null)
            return false;
        if (getClass() != obj.getClass())
            return false;
        SimpleLayer other = (SimpleLayer) obj;
        return name.equals(other.name);
    }

    @Override
    public void addLayerListener(ILayerListener l) {
        listeners.add(l);
    }

    @Override
    public void removeLayerListener(ILayerListener l) {
        listeners.remove(l);
    }

    protected void fireLayerChanged(LayerChangeEvent event) {
        for (ILayerListener l : listeners) {
            l.layerChanged(event);
        }
    }

    @Override
    public String toString() {
        return getClass().getSimpleName() + "[" + name + "]";
    }

}
